package com.docomo_um.validator;

import java.util.ArrayList;
import java.util.List;

import com.docomo_um.util.StringUtil;


public class ShortMessagePhoneNumberValidator implements Validator {

	private static final int MAX = 20;

	private static final List<String> illegalPrefix = new ArrayList<String>() {{
		add("184");
		add("186");
	}};

	public ShortMessagePhoneNumberValidator() {

	}

	@Override
	public boolean validate(Object param) {

		String phoneNumber = (String)param;
		if(StringUtil.isEmpty(phoneNumber)) {
			return false;
		}
		for(String prefix : illegalPrefix) {
			if(phoneNumber.startsWith(prefix)) {
				return false;
			}
		}


		if(phoneNumber.length() > MAX) {
			if(!(phoneNumber.startsWith("+")) || (phoneNumber.length() - 1 > MAX)){
				return false;
			}
//			return false;
		}

		for(int i = 0; i < phoneNumber.length(); i++) {
			if(validateChar(phoneNumber.charAt(i)) == false) {
				if(i == 0) {
					if(phoneNumber.charAt(0) != '+' ){
						return false;
					}
				} else {
					return false;
				}
			}
		}
		return true;
	}

	private boolean validateChar(char c) {
		return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'C') || (c >= 'a' && c <= 'c') || (c == '*') || (c == '#');
//		return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'C') || (c >= 'a' && c <= 'c') || (c == '*') || (c == '#') || (c == '+');
//		return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'D') || (c >= 'a' && c <= 'd') || (c == '*') || (c == '#') || (c == '+');
	}
}
