package com.docomo_um.validator;

import com.docomo_um.util.StringUtil;


public class MailAddressValidator implements Validator {

	private boolean required = false;

	private int maxLen = 0;

	private boolean valid_group = false;

//	-> 文字種チェックメソッドに移動
//	private static final String validSymbol = "!#$%&'*+-/=?^_`{|}~";

//	-> デバッグ用
	private static final boolean LOG_ENABLE = false;
	private static void printLog(String str) {
		if(LOG_ENABLE) {
			System.out.println(str);
		}
	}

	public MailAddressValidator(boolean required, int maxLen, boolean valid_group) {

		this.required = required;
		this.maxLen = maxLen;
		this.valid_group = valid_group;
	}
	@Override
	public boolean validate(Object param) {

		String addr = (String)param;

		// 空文字列をチェックします。
		if(StringUtil.isEmpty(addr)) {
			return this.required == false;
		}

		// 長さをチェックします。
		if(addr.length() > this.maxLen) {
			return false;
		}

//		// addrに含まれるメールアドレスの数を取得、チェックします。
//		int numOfAddress = MailParser.numOfAddress(addr);
//		if(numOfAddress > 1) {
//printLog("numOfAddress=["+numOfAddress+"]");
//			return false;
//		}

		// addrが"group"がどうか判断(":～;"があるか無いか)して、チェック処理を行います。
		// ";"以降はCFWSでないといけませんので、validateCfws(String)でチェックを行い、
		// CFWSで無い場合はエラーとします。
		int s = indexOf(addr, ':', 0);
		if(s >= 0) {
			if(valid_group == false) {
printLog("valid_group is false.");
				return false;
			}

			String group_list = null;
			int e = indexOf(addr, ';', s+1, FLAG_GROUP);
			if(e < s) {
printLog("s=["+s+"],e=["+e+"]");
				return false;
			}
			if(validateCfws(addr.substring(e+1)) == false) {
printLog("validateCfws("+addr.substring(e+1)+")");
				return false;
			}
			group_list = addr.substring(s+1, e);

			// アドレスの途中に'@'がなければ、CFWSの可能性が高いのでCFWSをチェックします。
			int index = indexOf(group_list, '@', 0);
			if(index < 0) {
				return validateCfws(group_list);
//			} else {
//				Iterator<String> it = new MailParser.AddrListIterator(group_list);
//				while(it.hasNext()) {
//					if(validateMailbox(it.next()) == false) {
//						return false;
//					}
//				}
			}
			return true;
		} else {
			// もし、セミコロン';'が存在する場合は規約違反
			int e = indexOf(addr, ';', 0);
			if(e >= 0) {
printLog("; only failed.");
				return false;
			}

			// "mailbox"のチェック
			return validateMailbox(addr);
		}
	}
//	-> RFC5322で定義されている、"mailbox"をチェックするメソッドを追加
	/*
	 * RFC5322で定義されている、"mailbox"をチェックします。
	 * 廃止されたフォーマット（obs-xxx）は、送信時には扱ってはいけません（MUST）ので、無視します。
	 *
	 * [RFC5322 3.2.1. Quoted characters]より抜粋
	 * quoted-pair     =   ("\" (VCHAR / WSP)) / obs-qp
	 *
	 * [RFC5322 3.2.2. Folding White Space and Comments]より抜粋
	 * FWS             =   ([*WSP CRLF] 1*WSP) /  obs-FWS   ; Folding white space
	 * ctext           =   %d33-39 /                        ; Printable US-ASCII
	 *                     %d42-91 /                        ;  characters not including
	 *                     %d93-126 /                       ;  "(", ")", or "\"
	 *                     obs-ctext
	 * ccontent        =   ctext / quoted-pair / comment
	 * comment         =   "(" *([FWS] ccontent) [FWS] ")"
	 * CFWS            =   (1*([FWS] comment) [FWS]) / FWS
	 *
	 * [RFC5322 3.2.3 Atom]より抜粋
	 * atext           =   ALPHA / DIGIT /    ; Printable US-ASCII
	 *                     "!" / "#" /        ;  characters not including
	 *                     "$" / "%" /        ;  specials.  Used for atoms.
	 *                     "&" / "'" /
	 *                     "*" / "+" /
	 *                     "-" / "/" /
	 *                     "=" / "?" /
	 *                     "^" / "_" /
	 *                     "`" / "{" /
	 *                     "|" / "}" /
	 *                     "~"
	 * atom            =   [CFWS] 1*atext [CFWS]
	 * dot-atom-text   =   1*atext *("." 1*atext)
	 * dot-atom        =   [CFWS] dot-atom-text [CFWS]
	 * specials        =   "(" / ")" /        ; Special characters that do
	 *                     "<" / ">" /        ;  not appear in atext
	 *                     "[" / "]" /
	 *                     ":" / ";" /
	 *                     "@" / "\" /
	 *                     "," / "." /
	 *                     DQUOTE
	 *
	 * [RFC5322 3.2.4. Quoted Strings]より抜粋
	 * qtext           =   %d33 /             ; Printable US-ASCII
	 *                     %d35-91 /          ;  characters not including
	 *                     %d93-126 /         ;  "\" or the quote character
	 *                     obs-qtext
	 * qcontent        =   qtext / quoted-pair
	 * quoted-string   =   [CFWS]
	 *                     DQUOTE *([FWS] qcontent) [FWS] DQUOTE
	 *                     [CFWS]
	 *
	 * [RFC5322 3.2.5. Miscellaneous Tokens]より抜粋
	 * word            =   atom / quoted-string
	 * phrase          =   1*word / obs-phrase
	 * unstructured    =   (*([FWS] VCHAR) *WSP) / obs-unstruct
	 *
	 * [RFC5322 3.4. Address Specification]より抜粋
	 * address         =   mailbox / group
	 * mailbox         =   name-addr / addr-spec
	 * name-addr       =   [display-name] angle-addr
	 * angle-addr      =   [CFWS] "<" addr-spec ">" [CFWS] / obs-angle-addr
	 * group           =   display-name ":" [group-list] ";" [CFWS]
	 * display-name    =   phrase
	 * mailbox-list    =   (mailbox *("," mailbox)) / obs-mbox-list
	 * address-list    =   (address *("," address)) / obs-addr-list
	 * group-list      =   mailbox-list / CFWS / obs-group-list
	 *
	 * [RFC5322 3.4.1. Addr-Spec Specification]より抜粋
	 * addr-spec       =   local-part "@" domain
	 * local-part      =   dot-atom / quoted-string / obs-local-part
	 * domain          =   dot-atom / domain-literal / obs-domain
	 * domain-literal  =   [CFWS] "[" *([FWS] dtext) [FWS] "]" [CFWS]
	 * dtext           =   %d33-90 /          ; Printable US-ASCII
	 *				       %d94-126 /         ;  characters not including
	 *				       obs-dtext          ;  "[", "]", or "\"
	 */
	private boolean validateMailbox(String mailbox) {

		String addr = mailbox;

		// "<"と">"で囲まれているアドレスを抽出する。
		// "display-name"は表示用文字列ですので、特にチェックしません。
		// ">"以降はCFWSでないといけませんので、validateCfws(String)でチェックを行い、
		// CFWSで無い場合はエラーとします。
		int s = indexOf(mailbox, '<', 0);
		if(s >= 0) {
			int e = indexOf(mailbox, '>', s+1);
			if(e < s) {
printLog("s=["+s+"],e=["+e+"]");
				return false;
			}
			if(validateCfws(mailbox.substring(e+1)) == false) {
printLog("validateCfws("+mailbox.substring(e+1)+")");
				return false;
			}
			addr = mailbox.substring(s+1, e);
		}

printLog("addr=[" + addr + "]");

		// アドレスの途中に'@'があること
		int index = indexOf(addr, '@', 0);
		if(index <= 0 || index >= addr.length() - 1) {
printLog("no @. index=["+index+"]");
			return false;
		}

		// '@'の前半(local)と後半(domain)に分ける。
		String local = addr.substring(0, index).trim();
		String domain = addr.substring(index + 1).trim();


		// ドメイン部をチェック

		// domain-literalの場合、[]の中身を抽出する。
		// domain-literalの前後はCFWSでないといけませんので、validateCfws(String)でチェックを行い、
		// CFWSで無い場合はエラーとします。
		s = indexOf(domain, '[', 0);
		if(s >= 0) {
			int e = indexOf(domain, ']', s+1, FLAG_LITERAL);
			if(e < s) {
printLog("s=["+s+"],e=["+e+"]");
				return false;
			}
			if(validateCfws(domain.substring(0,s)) == false) {
				return false;
			}
			if(validateCfws(domain.substring(e+1)) == false) {
				return false;
			}
			domain = domain.substring(s+1, e);
printLog("domain=["+domain+"]");
			for(int i = 0; i < domain.length(); i++) {
				char c = domain.charAt(i);
				if(dtext(c) == false && fws(c) == false) {
printLog("local invalid char=[" + c + "]");
					return false;
				}
			}
		} else {
printLog("domain=["+domain+"]");

			// '.'が先頭と末尾にないこと。2個以上連続していないこと （dot-atomの規約違反）
			if(domain.startsWith(".") || domain.endsWith(".") || domain.indexOf("..") >= 0) {
printLog("dot-atom failed.");
				return false;
			}

			// 文字種チェック
			// ※コメント内部は無視するようにします。
			int comment_count = 0;
			for(int i = 0; i < domain.length(); i++) {
				char c = domain.charAt(i);
				if(c == '(') {
					if(comment_count == 0 || domain.charAt(i-1) != '\\') {
						comment_count += 1;
						continue;
					}
				} else if(c == ')') {
					if(i > 0 && domain.charAt(i-1) != '\\') {
						comment_count -= 1;
						continue;
					}
				}
				if(comment_count == 0 && dot_atom(c) == false) {
printLog("domain invalid char=[" + c + "]");
					return false;
				}
			}
			// コメントの途中でチェック処理が終了した場合は不正なアドレス。
			if(comment_count != 0) {
printLog("domain comment_count=[" + comment_count + "]");
				return false;
			}
		}

		// ローカル部をチェック

		// quoted-stringの場合、""の中身を抽出する。
		// quoted-stringの前後はCFWSでないといけませんので、validateCfws(String)でチェックを行い、
		// CFWSで無い場合はエラーとします。
		s = indexOf(local, '"', 0);
		if(s >= 0) {
			int e = indexOf(local, '"', s+1, FLAG_DQUOTE);
			if(e < s) {
printLog("s=["+s+"],e=["+e+"]");
				return false;
			}
			if(validateCfws(local.substring(0,s)) == false) {
				return false;
			}
			if(validateCfws(local.substring(e+1)) == false) {
				return false;
			}
			local = local.substring(s+1, e);
printLog("local=["+local+"]");
			for(int i = 0; i < local.length(); i++) {
				char c = local.charAt(i);
				if(c == '\\' && i+1 < local.length() && quoted_pair(c, local.charAt(i+1))) {
					i += 1;
					continue;
				}
				if(	qtext(c) == false &&
					fws(c) == false) {
printLog("local invalid char=[" + c + "]");
					return false;
				}
			}
		} else {
printLog("local=["+local+"]");
			// '.'が先頭と末尾にないこと。2個以上連続していないこと （dot-atomの規約違反）
			if(local.startsWith(".") || local.endsWith(".") || local.indexOf("..") >= 0) {
printLog("dot-atom failed.");
				return false;
			}

			// 文字種チェック
			// ※コメント内部は無視するようにします。
			int comment_count = 0;
			for(int i = 0; i < local.length(); i++) {
				char c = local.charAt(i);
				if(c == '(') {
					if(comment_count == 0 || local.charAt(i-1) != '\\') {
						comment_count += 1;
						continue;
					}
				} else if(c == ')') {
					if(i > 0 && local.charAt(i-1) != '\\') {
						comment_count -= 1;
						continue;
					}
				}
				if(comment_count == 0 && dot_atom(c) == false) {
printLog("local invalid char=[" + c + "]");
					return false;
				}
			}
			// コメントの途中でチェック処理が終了した場合は不正なアドレス。
			if(comment_count != 0) {
printLog("local comment_count=[" + comment_count + "]");
				return false;
			}
		}

		return true;
	}

	private boolean validateCfws(String cfws) {

		int comment_count = 0;
		for(int i = 0; i < cfws.length(); i++) {
			char c = cfws.charAt(i);
			if(c == '(') {
				if(comment_count == 0 || cfws.charAt(i-1) != '\\') {
					comment_count += 1;
					continue;
				}
			} else if(c == ')') {
				if(i > 0 && cfws.charAt(i-1) != '\\') {
					comment_count -= 1;
					continue;
				}
			}
			if(comment_count == 0 && fws(c) == false) {
printLog("validateCfws c=[" + c + "]");
				return false;
			}
		}
		return true;
	}

	private boolean dtext(char c) {
		return	(c >= 33 && c <= 90) ||
				(c >= 94 && c <= 126);
	}

	private boolean wsp(char c) {
		return c == ' ' || c == '\t';
	}
	private boolean fws(char c) {
		return wsp(c) || c == '\r' || c == '\n';
	}

	private boolean dot_atom(char c) {
		final String validSymbol = "!#$%&'*+-/=?^_`{|}~.";
		return 	Checker.CheckHalfAlphabet(c) ||
				Checker.CheckHalfNumber(c) ||
				validSymbol.indexOf(c) >= 0;
	}

	private boolean qtext(char c) {
		return 	c == 33 ||
				(c >= 35 && c <= 91) ||
				(c >= 93 && c <= 126);
	}

	private boolean quoted_pair(char b, char c) {
		return b == '\\' && ((c >= 33 && c <= 126) || wsp(c));
	}

	final int FLAG_GROUP = 0x01;
	final int FLAG_COMMENT = 0x02;
	final int FLAG_DQUOTE = 0x04;
	final int FLAG_LITERAL = 0x08;
	private int indexOf(String addr, char key, int startIndex) {
		return indexOf(addr, key, startIndex, 0);
	}
	private int indexOf(String addr, char key, int startIndex, int init) {

		int state = init;
		int comment_count = 0;
		int index = 0;
		for(index = startIndex;
			index < addr.length() && (addr.charAt(index) != key || state != 0);
			index++) {

			char c = addr.charAt(index);

			if(state == 0) {
				switch(c) {
				case ':':		// group の開始
					state |= FLAG_GROUP;
					break;
				case '(':		// コメント の開始
					state |= FLAG_COMMENT;
					comment_count += 1;
					break;
				case '\"':		// DQUOTE の開始
					state |= FLAG_DQUOTE;
					break;
				case '[':		// domain-literal の開始
					state |= FLAG_LITERAL;
					break;
				default:
					break;
				}
			} else {
				// もし、一つ前の文字が'\'の場合は、quoted-pairとみなしてcontinueする。
				if(index > 0 && addr.charAt(index-1) == '\\') {
					continue;
				}
				switch(c) {
				case ';':		// group の終了
					state &= ~FLAG_GROUP;
					break;
				case '(':		// コメント の開始（ネスト）
					comment_count += 1;
					break;
				case ')':		// コメント の終了
					comment_count -= 1;
					if(comment_count == 0) {
						state &= ~FLAG_COMMENT;
					}
					break;
				case '\"':		// DQUOTE の終了
					state &= ~FLAG_DQUOTE;
					break;
				case ']':		// domain-literal の終了
					state &= ~FLAG_LITERAL;
					break;
				default:
					break;
				}

				// 引数keyが上記の文字で、かつ、stateが0になった場合は、検索を終了する。
				if(state == 0 && ";)\"]".indexOf(key) >= 0 && c == key) {
					break;
				}
			}
		}
		if(index >= addr.length()) {
			return -1;
		}
		return index;
	}
}
