package com.docomo_um.validator;

public class Checker {

	/** 半角数字か否かをチェックします。 */
	public static boolean CheckHalfNumber(char c) {
		
		return (c >= '0' && c <= '9');
	}

	/** 半角大英字か否かをチェックします。 */
	public static boolean CheckHalfAlphabetUpper(char c) {
		
		return (c >= 'A' && c <= 'Z');
	}

	/** 半角小英字か否かをチェックします。 */
	public static boolean CheckHalfAlphabetLower(char c) {
		
		return (c >= 'a' && c <= 'z');
	}
	
	/** 半角英字か否かをチェックします。 */
	public static boolean CheckHalfAlphabet(char c) {
		
		return CheckHalfAlphabetUpper(c) || CheckHalfAlphabetLower(c);
	}
	
	/** 半角空白か否かをチェックします。 */
	public static boolean CheckHalfSpace(char c) {
		
		return c == ' ';
	}
	
	/** 半角記号か否かをチェックします。 */
	public static boolean CheckHalfSymbol(char c) {
		
		return 		(c >= '!' && c <= '/') || (c >= ':' && c <= '@')
				||	(c >= '[' && c <= '`') || (c >= '{' && c <= '~');
	}
	
	/** 16進数の文字か否かをチェックします。 */
	public static boolean CheckHexCharacter(char c) {
		
		return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f');
	}
}

