package com.docomo_um.util;

import com.docomo_um.win.Logging;

/**
 * タイマ処理の失敗が原因で発生する例外クラスです。
 */
public class TimerException extends Exception {

	/**
	 *例外の詳細メッセージを設定しないでインスタンスを生成します。 
	 */
	public TimerException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。 
	 * @param msg 詳細メッセージを指定します。
	 */
	public TimerException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "TimerException", msg);
	}
}
