/**
 * セキュアなパケット通信を行うためのクラスを定義します。
 * 
 * <p>
 * SSL(Secure Socket Layer)やTLS(Transport Layer Security)を利用したパケット通信を行うことが出来ます。<br>
 * 通信されるデータは全て暗号化され、データの盗聴を防ぎ機密性を保護します。
 * また証明書による認証を行うことにより、データの完全性およびデータが本物であることをチェックします。
 * 認証に失敗した場合は、データの通信を行うことは出来ません。また、切断をする必要もありません。
 * </p>
 * <p>
 * 認証に必要ないくつかの証明書は、既に内部に保持されています。
 * 信頼出来る証明書を追加したい場合は、{@link com.docomo_um.module.net.ssl.KeyStore}を使用してください。
 * 認証時には、内部に保持されている証明書と、追加した証明書で認証を行います。
 * </p>
 */

package com.docomo_um.module.net.ssl;

