package com.docomo_um.module.net.ssl;

import java.io.IOException;
import java.io.InputStream;

import com.docomo_um.win.Logging;

/**
 * X509 証明書オブジェクトを作成するクラスです。
 */
public class X509CertificateFactory {
	/** 自身のインスタンス */
	private static X509CertificateFactory certificateFactoryInstance = new X509CertificateFactory();;
	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	private X509CertificateFactory() {

	}

	/**
	 * X509 証明書オブジェクトを作成するクラスのインスタンスを返却します。
	 * @return X509 証明書オブジェクトを作成するクラスのインスタンスを返します。
	 */
	public static X509CertificateFactory getInstance() {
		return certificateFactoryInstance;
	}

	/**
	 * 証明書オブジェクトを生成します。
	 * 
	 * <p>
	 * 入力ストリームから読み出されたデータを使ってこの証明書オブジェクトを初期化します。
	 * </p>
	 * 
	 * @param is 証明書データを持つ入力ストリームを指定します。
	 * @return 証明書オブジェクトを返します。
	 * @throws NullPointerException isがnullの場合に発生します。
	 * @throws IOException 入力ストリームからデータを読み込み中にエラーが発生した場合に発生します。
	 * @throws IllegalCertificateException 証明書のフォーマットに不正がある場合に発生します。
	 */
	public X509Certificate generateCertificate(InputStream is) throws IOException, IllegalCertificateException {
		Logging.getInstance().putMethod(this, "generateCertificate", is.toString());
		if (SSLProperties.getInstance().getIllegalCertificateException()) {
			throw new IllegalCertificateException(SSLProperties.getInstance().getIllegalCertificateExceptionMessage());
		}
		return new X509Certificate();
	}
}
