package com.docomo_um.module.net.ssl;

import java.io.IOException;
import java.net.UnknownHostException;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.win.Logging;


/**
 * SecureSocketオブジェクトを作成するクラスです。
 */
public class SecureSocketFactory {

	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	SecureSocketFactory() {

	}

	/**
	 * SecureSocketオブジェクトを作成します。
	 *
	 * <p>
	 * 指定されたhostとportでセキュアなソケットを作成します。
	 * 本メソッドはソケットの作成のみで、ホストとのハンドシェイクは行いません。ハンドシェイクを行うには、{@link SecureSocket#startHandshake()}をコールしてください。
	 * </p>
	 *
	 * @param host 接続先サーバホストを指定します。
	 * @param port 接続先サーバポートを指定します。
	 * @return 指定されたホストとポートに接続されるSecureSocketオブジェクトを返します。
	 * @throws NullPointerException hostがnullの場合に発生します。
	 * @throws IllegalArgumentException portに0以下の値を指定した場合や、portに65536以上の値を指定した場合に発生します。
	 * @throws IOException ソケットの作成中に入出力エラーが発生した場合に発生します。
	 * @throws UnknownHostException ホストが不明の場合に発生します。
	 * @throws CommunicationFailureException 通信異常の場合に発生します。
	 */
	public SecureSocket createSocket(String host, int port) throws UnknownHostException, IOException, CommunicationFailureException {
		Logging.getInstance().putMethod(this, "createSocket", host, String.valueOf(port));
		if (ModuleProperties.getInstance().getCommunicationFailureException()) {
			throw new CommunicationFailureException(ModuleProperties.getInstance().getCommunicationFailureExceptionStatus(), ModuleProperties.getInstance().getCommunicationFailureExceptionMessage());
		}
		return new SecureSocket(host, port);
	}
}
