package com.docomo_um.module.net.ssl;

import com.docomo_um.win.Logging;

/**
 * セキュアソケットプロトコルの実装を表すクラスです。
 */
public class SecureContext {
	/** 自身のインスタンス */
	private static SecureContext secureContextInstance = null;

	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	private SecureContext() {

	}

	/**
	 * SecureContextオブジェクトを生成します。
	 * 
	 * <p>
	 * このメソッドを複数回呼び出した場合には、同一インスタンスを返します。
	 * </p>
	 * 
	 * @return SecureContextのオブジェクトを返します。
	 */
	synchronized public static SecureContext getInstance() {
		if (secureContextInstance == null) {
			secureContextInstance = new SecureContext();
		}
		Logging.getInstance().putMethod(secureContextInstance, "getInstance");
		return secureContextInstance;
	}

	/**
	 * このコンテキストのSecureSocketFactoryオブジェクトを返します。
	 * @return SecureSocketFactoryオブジェクトを返します。
	 */
	public SecureSocketFactory getSocketFactory() {
		Logging.getInstance().putMethod(this, "getSocketFactory");
		return new SecureSocketFactory();
	}
}
