package com.docomo_um.module.net.ssl;

public class SSLProperties {
	private static SSLProperties sslPropertiesInstance;

	private boolean illegalCertificateException;			// IllegalCertificateExceptionの発生の有無を指定
	private String illegalCertificateExceptionMessage;		// IllegalCertificateExceptionのメッセージ

	private boolean secureHandshakeException;				// SecureHandshakeExceptionの発生の有無を指定
	private int secureHandshakeExceptionStatus;				// SecureHandshakeExceptionのステータス
	private String 	secureHandshakeExceptionMessage;		// SecureHandshakeExceptionのメッセージ


	public static SSLProperties getInstance() {
		if (sslPropertiesInstance == null) {
			sslPropertiesInstance = new SSLProperties();
		}
		return sslPropertiesInstance;
	}

	/**
	 * IllegalCertificateExceptionの発生の有無を指定
	 * @param enable
	 */
	public void setIllegalCertificateException(boolean enable) {
		setIllegalCertificateException(enable, null);
	}

	/**
	 * IllegalCertificateExceptionの発生の有無を指定
	 * @param enable
	 * @param message
	 */
	public void setIllegalCertificateException(boolean enable, String message) {
		illegalCertificateException = enable;
		illegalCertificateExceptionMessage = message;
	}

	public boolean getIllegalCertificateException() {
		return illegalCertificateException;
	}

	public String getIllegalCertificateExceptionMessage() {
		return illegalCertificateExceptionMessage;
	}

	/**
	 * SecureHandshakeExceptionの発生の有無を指定
	 * @param enable
	 * @param status
	 * @param message
	 */
	public void setSecureHandshakeException(boolean enable, int status, String message) {
		secureHandshakeException = enable;
		secureHandshakeExceptionStatus = status;
		secureHandshakeExceptionMessage = message;
	}

	/**
	 * SecureHandshakeExceptionの発生の有無を取得
	 * @return
	 */
	public boolean getSecureHandshakeException() {
		return secureHandshakeException;
	}

	public int getSecureHandshakeExceptionStatus() {
		return secureHandshakeExceptionStatus;
	}

	public String getSecureHandshakeExceptionMessage() {
		return secureHandshakeExceptionMessage;
	}
}
