package com.docomo_um.module.net.ssl;

import com.docomo_um.win.Logging;

/**
 * 証明書の格納場所を表すクラスです。
 */
public class KeyStore {
	/** 自身のインスタンス */
	private static KeyStore keyStore = new KeyStore();
	/** X509証明書 */
	X509Certificate certificate;
	/** SSL接続時に、指定した証明書の有効期限が切れていても接続を試みます。*/
	boolean autoAuth;
	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	private KeyStore() {

	}

	/**
	 * キーストアを生成します。
	 * @return キーストアを返します。
	 */
	public static KeyStore getInstance() {
		Logging.getInstance().putMethod(keyStore, "getInstance");
		return keyStore;
	}

	/**
	 * 信頼出来る証明書を設定します。
	 *
	 * <p>
	 * 設定出来る証明書は一つだけです。
	 * このメソッドを複数回呼出した場合、最後に登録した証明書だけが有効になります。
	 * null を設定すると、証明書の設定を削除します。
	 * </p>
	 * <p>
	 * このメソッドで設定された証明書は以下で使用されます。また、証明書の有効期限切れ等、認証に失敗した場合に発生する例外は以下になります。
	 * <ul>
	 * <li>{@link SecureSocket}によるハンドシェーク。認証失敗時は{@link SecureHandshakeException}が発生します。</li>
	 * <li>メールの送受信。認証失敗時は{@link SecureHandshakeException}が発生します。</li>
	 * </ul>
	 * </p>
	 *
	 * @param cert 信頼出来る証明書を指定します。
	 * @param autoAuth trueを指定した場合、SSL接続時に、指定した証明書の有効期限が切れていても接続を試みます。
	 * falseを指定した場合、SSL接続時に、指定した証明書の有効期限が切れている場合は例外が発生します。
	 */
	public void setCertificate(X509Certificate cert, boolean autoAuth) {
		Logging.getInstance().putMethod(this, "setCertificate", cert == null ? null : cert.toString(), String.valueOf(autoAuth));
		certificate = cert;
		this.autoAuth = autoAuth;
	}

	/**
	 * 設定した信頼出来る証明書を取得します。
	 * 設定されていない場合はnullを返します。
	 * @return 証明書を返します。
	 */
	public X509Certificate getCertificate() {
		Logging.getInstance().putMethod(this, "getCertificate");
		return certificate;
	}

}


