/**
 *無線通信に関するクラスを定義します。
 *<p>
 *本パッケージが提供する機能は次の通りです。<br>
 *<ul>
 *<li>回線交換を使用して、音声通信を行います。</li>
 *<li>パケット交換を使用して、パケット通信を行います。</li>
 *<li>SMSの送受信と、CBS・ETWSの受信を行います。</li>
 *<li>メールの送受信を行います。</li>
 *<li>USSDの送受信を行います。</li>
 *</ul>
 *</p>
 *<p>
 *用語定義<br>
 *<ul>
 *<li>
 *PDPタイプ:<br>
 *Packet Data Protocolのことを示します。IPとPPPの2つがあります。<br>
 *</li>
 *<li>
 *IP情報、PPP情報:<br>
 *パケット通信を行う際に設定する情報をまとめたものです。設定する情報としては次のものがあります。<br>
 *<ul>
 *<li>ユーザ認証方式</li>
 *<li>ユーザ名</li>
 *<li>パスワード</li>
 *<li>IPアドレスの割り当て方式</li>
 *<li>自ホストのIPアドレス</li>
 *<li>DNSの割り当て方式</li>
 *<li>プライマリDNSのIPアドレス</li>
 *<li>セカンダリDNSのIPアドレス</li>
 *</ul>
 *</li>
 *<li>
 *SMS:<br>
 *Short Message Serviceのことを示します。携帯電話やPHS同士で短文を送受信するサービスです。<br>
 *</li>
 *<li>
 *SMSステータスレポート:<br>
 *送信済のSMSメッセージに関する配信結果を、送信元に通知するメッセージです。例えば、サービスセンターがメッセージを転送することが可能であったか、
 *再送のためにサービスセンターに蓄積されたか、等についての情報を提供します。<br>
 *SMSステータスレポート内にはメッセージ送信番号({@link com.docomo_um.module.net.ShortMessage#ATTR_MR})が記録されており、
 *{@link com.docomo_um.module.net.ShortMessageBox#send(ShortMessage, boolean, int)}と{@link com.docomo_um.module.net.ShortMessageBox#send(int, boolean, int)}の戻り値である
 *メッセージ送信番号と紐付けられます。
 *</li>
 *<li>
 *CBS、ETWS:<br>
 *CBSは、Cell Broadcast Serviceのことを示します。<br>
 *ETWSは、Earthquake and Tsunami Warning Systemのことを示します。<br>
 *気象庁が配信する緊急地震速報などを、回線混雑の影響を受けずに受信することができる緊急速報「エリアメール」です。<br>
 *</li>
 *<li>
 *USSD<br>
 *Unstructured Supplementary Service Dataのことを示します。
 *ネットワーク上のアプリケーションとテキストを送受信するために使用されます。
 *</li>
 *</ul>
 *</p>
 *<p>
 *<p>
 *<b>留意事項</b><br>
 *</p>
 *<p>
 *UIMが挿入されていない状態でネットワーク通信を行うと、圏外相当の処理となります。<br>
 *</p>
 */

package com.docomo_um.module.net;

