package com.docomo_um.module.net;

/**
 *音声専用の情報(ガイダンスの開始等)を通知するリスナクラスです。
 *
 */
public interface VoiceControllerListener extends ModemControllerListener {

	/**
	 *ネットワークから音声ガイダンスを流す通知を受信した場合に呼ばれます。
	 *ただし、本通知はタイミングを規定するものではありません。そのため、本メソッドが呼ばれた後、
	 *いずれかのタイミングで本セッションにネットワークから音声ガイダンスが流されます。
	 *音声呼接続完了後に音声ガイダンスが流される可能性もありますので、音声呼の処理は本メソッドとは別に実施する必要があります。
	 *
	 * @param controller このリスナが設定されているインスタンスが設定されています。
	 * @param session 接続インスタンスが設定されています。
	 */
	void onReceivingGuidance(VoiceController controller, VoiceSession session);

}
