package com.docomo_um.module.net;

import com.docomo_um.win.Logging;

/**
 * USSDサービスの通信失敗が原因で発生する例外クラスです。
 */
public class USSDServiceException extends Exception{

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。 
	 */
	public USSDServiceException() {
		this(null);
	}


	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。
	 * @param msg 詳細メッセージを指定します。
	 */
	public USSDServiceException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "USSDServiceException");
	}
}
