package com.docomo_um.module.net;

import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleInfo;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;

public class USSDFunctions {
	/** ターミナルI/F用リスナ */
	private static USSDServiceTerminalListener terminalListener;
	/** リスナ */
	private static USSDServiceListener ussdListener;

	public static void setTerminalListener(USSDServiceTerminalListener listener) {
		terminalListener = listener;
	}

	public static boolean received(String message) {
		char[] messageArray = message.toCharArray();
		for (int i = 0; i < messageArray.length; i++) {
			if (messageArray[i] < '0' || messageArray[i] > '9') {
				if (messageArray[i] != '#' && messageArray[i] != '*') {
					return false;
				}
			}
		}
		if (ussdListener != null) {
			ussdListener.onReceived(message);
		}
		return true;
	}

	public static void send(String message) throws RegulationException, ExternalStatusException, USSDServiceException {
		if (!availableMessage(message)) {
			throw new IllegalArgumentException();
		}
		if ((ModuleProperties.getInstance().getRegulation() & ModuleInfo.REGULATION_VOICE) != 0) {
			// 音声規制時
			throw new RegulationException();
		}
		if (!ModuleProperties.getInstance().getUIM()) {
			throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
		}
		if (NetProperties.getInstance().getUSSDServiceException()) {
			// USSDの送信に失敗
			throw new USSDServiceException(NetProperties.getInstance().getUSSDServiceExceptionMessage());
		}
		if (terminalListener != null) {
			terminalListener.onSend(message);
		}
	}
	static void setListener(USSDServiceListener listener) {
		ussdListener = listener;
	}
	static boolean availableMessage(String message) {
		char[] messageArray = message.toCharArray();
		if (messageArray[0] != '#' && messageArray[0] != '*') {
			return false;
		}
		for (int i = 1; i < messageArray.length; i++) {
			if (messageArray[i] < '0' || messageArray[i] > '9') {
				if (messageArray[i] != '#' && messageArray[i] != '*') {
					return false;
				}
			}
		}
		return true;
	}
}
