package com.docomo_um.module.net;


/**
 * メッセージの状態を通知するリスナクラスです。
 *
 */
public interface ShortMessageListener {

	/**
	 * SMS、または、SMSステータスレポートのメッセージを受信した場合にコールされます。
	 * <p>
	 * 受信時のメッセージは {@link ShortMessage#STAT_UNREAD} 状態です。
	 * 本メソッドの引数messageBoxに設定する{@link MessageBox}のインスタンスは、{@link ShortMessageManager#getShortMessageBox()}、
	 * または{@link ShortMessageManager#getSMSStatusReportBox()}で取得するインスタンスと同一のインスタンスです。
	 * </p>
	 * @param messageBox 受信したメッセージを格納したメッセージボックスが設定されます。
	 * @param messageNumber 受信したメッセージのメッセージ番号が設定されます。
	 * @param override 受信メッセージが他のメッセージを上書きして保存された場合はtrue、それ以外の場合はfalseが指定されます。
	 */
	void onSMSReceived(MessageBox messageBox, int messageNumber, boolean override);

	/**
	 * エリアメール(CBS・ETWS)を受信した場合にコールされます。
	 * <p>
	 * 本メソッドを用いてエリアメールを受信した際、メッセージは {@link ShortMessage#STAT_READ} 状態です。
	 * </p>
	 * @param message 受信したメッセージが設定されます。
	 * @param override 受信メッセージが他のメッセージを上書きして保存された場合はtrue、それ以外の場合はfalseが指定されます。
	 */
	void onAreaMailReceived(ShortMessage message, boolean override);

	/**
	 * SMS、または、SMSステータスレポートを受信できなかった場合にコールされます。
	 * <p>
	 * 本メソッドの引数messageBoxに設定する{@link MessageBox}のインスタンスは、{@link ShortMessageManager#getShortMessageBox()}、
	 * または{@link ShortMessageManager#getSMSStatusReportBox()}で取得するインスタンスと同一のインスタンスです。
	 * </p>
	 * <p>
	 * SMS、または、SMSステータスレポートのメッセージを受信した際に、メッセージボックスに空きがなく、
	 * 且つ、保存されているメッセージがすべて未読({@link ShortMessage#STAT_UNREAD})である場合、
	 * メッセージの受信が拒否され当該メソッドがコールされます。
	 * </p>
	 * <p>
	 * 任意のメッセージの状態が既読{@link ShortMessage#STAT_READ}になる、または保存領域に空きができると、
	 * システムは自動的にメッセージの受信を開始し、{@link #onSMSReceived(MessageBox, int, boolean)} がコールされます。
	 * </p>
	 *
	 * @param messageBox 受信できなかったメッセージボックスが設定されます。
	 */
	void onSMSBoxFull(MessageBox messageBox);
}