package com.docomo_um.module.net;

import com.docomo_um.module.DeviceException;

public class ShortMessageFunctions {
	public static final int MASK_MESSAGE_NUMBER = 0x00FF;
	public static final int PREFIX_SHORTMESSAGE = 0x1000;
	public static final int PREFIX_AREAMAIL     = 0x2000;
	public static final int PREFIX_STATUSREPORT = 0x4000;
	public static final int PREFIX_UIM          = 0x0100;

	/** SMSセンター番号 */
	private static String scaNumber = null;
	/** 国際アクセスコード */
	private static String toscaNumber = null;

	public static void setSMSCenterNumber(String sca, String tosca) throws DeviceException, ShortMessageException {
		scaNumber = sca;
		toscaNumber = tosca;
	}
	public static String getSMSCenterNumber() {
		return scaNumber;
	}
	public static String getSMSInternationalAccessCode() {
		return toscaNumber;
	}
	public static boolean receiveSMS(String filename) throws DeviceException {
		ShortMessageManager smsMan = ShortMessageManager.getInstance();
		return smsMan.receiveSMS(filename);
	}
}
