package com.docomo_um.module.net;

import java.util.ArrayList;
import java.util.List;

import com.docomo_um.win.Logging;

/**
 * ショートメッセージの処理に失敗した場合に発生する例外クラスです。
 */
public class ShortMessageException extends Exception {


	/**
	 *ステータスが未定義であることを示します。
	 */
	public static final int UNDEFINED = 0;

	/**
	 * 保存領域に空きが無いことを示します。
	 */
	public static final int STORAGE_FULL = 1;

	/** ステータス値 */
	private int status = 0;

	private static final List<String> defmsg = new ArrayList<String>() {{
		add("Undefined external state exception occurred.");
		add("Storage full.");
	}};


	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定しないでインスタンスを生成します。
	 * ステータス値は UNDEFINED に設定されます。
	 */
	public ShortMessageException() {
		this(UNDEFINED);
	}

	/**
	 * 例外の原因を示すステータス値を設定してインスタンスを生成します。 
	 *
	 * @param status 設定するステータスの値を指定します。
	 */
	public ShortMessageException(int status) {
		this(status, defmsg.get(status));
	}

	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定してインスタンスを生成します。 
	 * @param status 設定するステータスの値を指定します。
	 * @param msg 詳細メッセージを指定します。
	 */
	public ShortMessageException(int status, String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "ShortMessageException", String.valueOf(status), msg);
		this.status = status;
	}

	/**
	 * 例外の原因を示すステータス値を取得します。
	 *
	 * @return 例外の原因を示すステータス値を返します。
	 */
	public int getStatus() {
		Logging.getInstance().putMethod(this, "getStatus");
		return status;
	}
}
