package com.docomo_um.module.net;

import java.util.ArrayList;
import java.util.List;

import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.IllegalSettingException;
import com.docomo_um.win.Logging;

/**
 *PacketControllerの実クラスです。
 *アプリケーション開発者向けには非公開です。
 */
public class PacketControllerImpl extends PacketController {
	/** セッションリスト */
	private static List<Session> sessionList = new ArrayList<Session>();
	/** リスナ */
	private ModemControllerListener modemControllerListener;
	/** ターミナルI/F用リスナ */
	private ModemControllerTerminalListener terminalListener;

	private SessionListener sessionListener = null;

	public PacketControllerImpl(){
		sessionListener = new MySessionListener(this);
	}
	public PacketControllerImpl(PDPTypeInfo pdpType){
		sessionListener = new MySessionListener(this);
	}
	public static List<Session> getSessionList()
	{
		return sessionList;
	}
	/**
	 * ターミナルI/Fへの通知用リスナの設定
	 */
	public void setModemControllerTerminalListener(ModemControllerTerminalListener listener) {
		terminalListener = listener;
	}

	@Override
	public Session createSession(String destination) {
		Logging.getInstance().putMethod(this, "createSession", destination);
		Session session;
		if (destination == null) {
			throw new NullPointerException();
		}
		for (int i = 0; i < sessionList.size(); i++) {
			session = sessionList.get(i);
			if (session.getDestination().equals(destination)) {
				return session;
			}
		}
		session = new PacketSession(destination);
		sessionList.add(session);
		session.setListener(sessionListener);
		return session;
	}
	@Override
	public void setModemControllerListener(ModemControllerListener listener) {
		Logging.getInstance().putMethod(this, "setModemControllerListener", listener == null ? null : listener.toString());
		modemControllerListener = listener;
	}
	/**
	 * 着信時処理
	 * @param incoming
	 * @return
	 * @throws SessionException
	 */
	public boolean incomingCall(Session incoming) throws SessionException
	{
		PacketSession session = (PacketSession)incoming;
		session.incoming();
		if (modemControllerListener != null) {
			modemControllerListener.onReceived(this, session);
		}
		return true;
	}
	public void disconnect(Session session) throws SessionException, CommunicationFailureException {
		PacketSession packetSession = (PacketSession)session;
		packetSession.disconnected();

	}
	public void receive(Session session) throws SessionException, CommunicationFailureException, IllegalSettingException {
		PacketSession packetSession = (PacketSession)session;
		packetSession.received();
	}
	/**
	 *現在パケット通信中のSessionを取得します。
	 *
	 *@return パケット通信中のSessionを返します。パケット通信中のSessionが無い場合はnullを返します。
	 */
	@Override
	public Session getConnectedSession() {
		Logging.getInstance().putMethod(this, "getConnectedSession");
		for (int i = 0; i < sessionList.size(); i++) {
			Session session = sessionList.get(i);
			if (session.getConnectedStatus() == Session.CONNECTION_STATUS_CONNECT) {
				return session;
			}
		}
		return null;
	}

	class MySessionListener implements SessionListener {
		PacketController packetController = null;
		MySessionListener(PacketController controller) {
			packetController = controller;
		}
		/**
		 * 相手からの着信によるステータス変化をアプリに通知
		 */
		@Override
		public void onIncoming(Session session) {
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
		}
		/**
		 * 自身の発信によるステータス変化をアプリに通知
		 */
		@Override
		public void onSend(Session session) {
			if (terminalListener != null) {
				terminalListener.onSend(packetController, session);
			}
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
		}
		/**
		 * 自身の応答拒否によるステータス変化をアプリに通知
		 */
		@Override
		public void onReject(Session session) {
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
			if (terminalListener != null) {
				terminalListener.onReject(packetController, session);
			}
		}
		/**
		 * 自身の応答によるステータス変化をアプリに通知
		 */
		@Override
		public void onReceive(Session session) {
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
			if (terminalListener != null) {
				terminalListener.onReceive(packetController, session);
			}
		}
		/**
		 * 相手が応答したことをアプリに通知
		 */
		@Override
		public void onReceived(Session session) {
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
		}
		/**
		 * 保留（パケットセッションでは不要）
		 */
		@Override
		public void onHold(Session session) {
			// nop
		}
		@Override
		public void onSendAnswering(Session session) {
			// nop
		}
		/**
		 * 自身の切断によるステータス変化をアプリに通知
		 */
		@Override
		public void onDisconnect(Session session) {
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
			if (terminalListener != null) {
				terminalListener.onDisconnect(packetController, session);
			}
		}
		/**
		 * 相手からの切断をアプリに通知
		 */
		@Override
		public void onDisconnected(Session session) {
			if (modemControllerListener != null) {
				modemControllerListener.onChangedStatus(packetController, session);
			}
			if (terminalListener != null) {
				terminalListener.onDisconnect(packetController, session);
			}
		}
		/**
		 * DTMF送信（パケットセッションでは不要）
		 */
		@Override
		public void onDTMF(Session session, String message) {
			// nop
		}
		/**
		 * 音声ガイダンス（パケットセッションでは不要）
		 */
		@Override
		public void onGuidance(Session session) {
			// TODO 自動生成されたメソッド・スタブ

		}
	};
}
