package com.docomo_um.module.net;

/**
 *パケット通信制御を表すクラスです。
 *<p>
 *発信は、{@link #createSession(String)} を使用して{@link PacketSession} のインスタンスを作成し、作成したインスタンスでパケット発信と切断を管理します。<br>
 *着信は、{@link #setModemControllerListener(ModemControllerListener)} で登録したリスナの引数として渡される{@link PacketSession} のインスタンスでパケット着信と切断を管理します。<br>
 *尚、同時に複数のセッションがAPNに接続することはできませんので、複数のセッションを使用する場合はアプリケーション側でセッションの接続と切断を適切に管理する必要があります。
 *</p>
 *
 *@see ModemController
 *@see PacketSession
 */
public abstract class PacketController extends ModemController {
	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	PacketController() {
	}

	/**
	 * パケット通信の接続を表すインスタンスを生成します。
	 *
	 * <p>
	 * 既に生成したAPNで再度生成する場合、生成済みのインスタンスが返却されます。
	 * </p>
	 *
	 * @param destination 接続先のAPNを指定します。
	 * @return 通信接続クラスのインスタンスを返します。
	 * @throws NullPointerException destinationにnullを指定した場合に発生します。
	 */
	@Override
	public Session createSession(String destination) {
		return null;
	}

	/**
	 * リスナを登録します。
	 * <p>
	 * パケット通信制御の状態を通知するイベントを受けることができます。<br>
	 * </p>
	 * <p>
	 * このインスタンスに登録できるリスナは1つだけです。 このメソッドを複数回呼出した場合、最後に登録したリスナだけが有効です。 null
	 * を指定すると、リスナの登録を削除します。
	 * </p>
	 *
	 * @param listener 登録するリスナを指定します。
	 */
	@Override
	public void setModemControllerListener(ModemControllerListener listener) {
	}
	/**
	 *現在パケット通信中のSessionを取得します。
	 *
	 *@return パケット通信中のSessionを返します。パケット通信中のSessionが無い場合はnullを返します。
	 */
	@Override
	public Session getConnectedSession() {
		return null;
	}

}
