package com.docomo_um.module.net;

/**
 *音声またはパケットの通信制御の状態を通知するリスナクラスです。
 *
 */
public interface ModemControllerListener {

	/**
	 *音声またはパケットの着信があった場合に呼ばれます。
	 *
	 *<p>
	 *このメソッドが呼び出された時点では接続は完了していません。
	 *{@link Session#receive()}を呼び出すことによって接続処理が行われます。
	 *</p>
	 *
	 *@param controller このリスナが設定されているインスタンスが設定されています。
	 *@param session 接続インスタンスが設定されています。
	 */
	void onReceived(ModemController controller, Session session);


	/**
	 *セッションの状態が変化した場合に呼ばれます。
	 *
	 *<p>
	 *{@link ModemController#createSession(String destination)}によって生成されたセッションインスタンス、
	 *もしくは着信時に内部で生成されたセッションインスタンスの参照が設定されます。
	 *{@link Session#getConnectedStatus()}によって状態を確認することができます。
	 *</p>
	 *
	 *@param controller このリスナが設定されているインスタンスが設定されています。
	 *@param session 状態が変化したセッションインスタンスが設定されています。
	 */
	void onChangedStatus(ModemController controller, Session session);

}
