package com.docomo_um.module.net;


/**
 *音声またはパケット通信の通信制御を表す抽象クラスです。
 *
 */

public abstract class ModemController {
	/**
	 *通信制御の一つとして、CS(回線交換)を表します。
	 */
	public static final int TYPE_CS =0;

	/**
	 *通信制御の一つとして、PS(パケット交換)を表します。
	 */
	public static final int TYPE_PS =1;

	/**
	 *通信制御の一つとして、その他を表します。
	 */
	public static final int TYPE_OTHER =2;

	/**
	 *CS(回線交換)の機能の一つとして、音声発信を表します。
	 *
	 *@see #TYPE_CS
	 */
	public static final int CS_VOICE  = 2;

	/**
	 *PS(パケット交換)の機能の一つとして、PDPタイプのPPPを表します。
	 *
	 *@see #TYPE_PS
	 */
	public static final int PS_PPP = 0;

	/**
	 *PS(パケット交換)の機能の一つとして、PDPタイプのIPを表します。
	 *
	 *@see #TYPE_PS
	 */
	public static final int PS_IP = 1;

	/**
	 *その他の機能の一つとして、緊急地震速報(CBS)を表します。
	 *
	 *@see #TYPE_OTHER
	 */
	public static final int OTHER_CBS = 0;

	/**
	 *その他の機能の一つとして、緊急地震速報(ETWS)を表します。
	 *
	 *@see #TYPE_OTHER
	 */
	public static final int OTHER_ETWS = 1;

	/**
	 *その他の機能の一つとして、SMSを表します。
	 *
	 *@see #TYPE_OTHER
	 */
	public static final int OTHER_SMS  = 2;

	/**
	 * その他の機能の一つとして、USSDを表します。
	 *
	 * @see #TYPE_OTHER
	 */
	public static final int OTHER_USSD = 3;
	/**
	 * その他の機能の一つとして、キャッチホンサービスを表します。
	 */
	public static final int OTHER_CALL_WAITING = 4;


	/**
	 *アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 *
	 */
	ModemController(){
	}

	/**
	 *通信制御がサポートする機能を取得します。
	 *
	 *<p>
	 *指定した種別において、サポートする機能の一覧を返します。サポートする機能がない場合には null を返します。
	 *</p>
	 *@param type 通信制御の種別({@link #TYPE_CS}、{@link #TYPE_PS}、{@link #TYPE_OTHER})を指定します。
	 *@return サポートする機能の一覧を返します。
	 *
	 *@throws IllegalArgumentException 通信制御種別として定義していない値を指定した場合に発生します。
	 */
	public static int[] getSupportedFunction(int type) {
//		Logging.getInstance().putMethod(this, "getSupportedFunction", String.valueOf(type));
		int[] func = null;
		switch (type) {
		case TYPE_CS:
			func = new int[1];
			func[0] = CS_VOICE;
			break;
		case TYPE_PS:
			func = new int[2];
			func[0] = PS_PPP;
			func[1] = PS_IP;
			break;
		case TYPE_OTHER:
			func = new int[4];
			func[0] = OTHER_CBS;
			func[1] = OTHER_ETWS;
			func[2] = OTHER_SMS;
			func[3] = OTHER_USSD;
			break;
		default:
			throw new IllegalArgumentException();
		}
		return func;
	}

	/**
	 *音声またはパケット通信の接続を表すインスタンスを生成します。
	 *
	 *@param destination 接続先を指定します。
	 *@throws NullPointerException destinationにnullが指定された場合に発生します。
	 *@throws IllegalArgumentException destinationが不正な場合に発生します。
	 *@throws SessionException destinationが電話発信対象外の番号の場合に発生します。
	 */
	public abstract Session createSession(String destination) throws SessionException;

	/**
	 *リスナを登録します。
	 *
	 *@param listener 登録するリスナを指定します。
	 */
	public abstract void setModemControllerListener(ModemControllerListener listener);

	/**
	 *現在接続中のSessionを取得します。
	 *
	 *@return 現在接続中のSessionを返します。接続中のSessionが無い場合はnullを返します。
	 */
	public abstract Session getConnectedSession();

}
