package com.docomo_um.module.net;

import java.util.ArrayList;
import java.util.List;

/**
 * メール処理の失敗が原因で発生する例外クラスです。
 */
public class MailException extends Exception {


	/**
	 *ステータスが未定義であることを示します。
	 */
	public static final int UNDEFINED = 0;

	/**
	 * ログインに失敗しました。
	 */
	public static final int LOGIN_FAILED = 1;

	/**
	 * ログアウト時のメールの削除に失敗しました。
	 */
	public static final int LOGOUT_DELETE_MAIL_FAILED = 2;

	/** ステータス値 */
	private int status = 0;

	private static final List<String> defmsg = new ArrayList<String>() {{
		add("Undefined external state exception occurred.");
		add("login failed.");
		add("Mail was not deleted.");
	}};
	

	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定しないでインスタンスを生成します。
	 * ステータス値は、UNDEFINEDに設定されます。 
	 */
	public MailException() {
		this(UNDEFINED);
	}

	/**
	 * 例外の原因を示すステータス値を設定してインスタンスを生成します。 
	 *
	 * @param status 設定するステータスの値を指定します。
	 */
	public MailException(int status) {
		this(status, defmsg.get(status));
	}

	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定してインスタンスを生成します。 
	 * @param status 設定するステータスの値を指定します。
	 * @param msg 詳細メッセージを指定します。
	 */
	public MailException(int status, String msg) {
		super(msg);
		this.status = status;
	}

	/**
	 * 例外の原因を示すステータス値を取得します。
	 *
	 * @return 例外の原因を示すステータス値を返します。
	 */
	public int getStatus() {
		return this.status;
	}
}
