package com.docomo_um.module.location;

import com.docomo_um.lang.Degree;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleInfo;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.module.location.LocationProvider;
import com.docomo_um.win.Logging;

/**
 *LocationProviderの実クラスです。
 *アプリケーション開発者向けには非公開です。
 */
public class LocationProviderImpl extends LocationProvider {
	static final int DEFAULT_LOCATION_TIMEOUT = 10000;
	private int mode;
	private int status;
	private ProviderLocationListener providerListener;


	public LocationProviderImpl(int method) {
		super(method);
		int[] availableMethod = getAvailableLocationMethod();
		for (int i = 0; i < availableMethod.length; i++) {
			if (method == availableMethod[i]) {
				this.status = STATUS_IDLE;
				return;
			}
		}
		throw new IllegalArgumentException();
	}
	@Override
	public int getMeasurementMode(){
		Logging.getInstance().putMethod(this, "getMeasurementMode");
		return mode;
	}
	@Override
	public void setMeasurementMode(int mode){
		Logging.getInstance().putMethod(this, "setMeasurementMode", String.valueOf(mode));
		int[] availableMode = LocationProperties.getInstance().getAvailableMode();
		for (int i = 0; i < availableMode.length; i++) {
			if (availableMode[i] == mode) {
				this.mode = mode;
				return;
			}
		}
		throw new IllegalArgumentException();
	}
	@Override
	public void interrupt() throws LocationException {
		Logging.getInstance().putMethod(this, "interrupt");
		if (LocationProperties.getInstance().getLocationException()) {
			throw new LocationException(LocationProperties.getInstance().getLocationExceptionStatus(), LocationProperties.getInstance().getLocationExceptionMessage());
		}
		if (status == STATUS_MEASUREMENT) {
			status = STATUS_IDLE;
		}
	}
	@Override
	public Location getLocation() throws LocationException, RegulationException, ExternalStatusException {
		Logging.getInstance().putMethod(this, "getLocation");
		if (!ModuleProperties.getInstance().getUIM()) {
			throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
		}
		if ((ModuleProperties.getInstance().getRegulation() & ModuleInfo.REGULATION_VOICE) != 0) {
			// 音声規制中状態
			throw new RegulationException();
		}
		switch (status) {
		case STATUS_MEASUREMENT:
		case STATUS_EMERGENCY:
			throw new IllegalStateException();
		}
		if (LocationProperties.getInstance().getLocationException()) {
			throw new LocationException(LocationProperties.getInstance().getLocationExceptionStatus(), LocationProperties.getInstance().getLocationExceptionMessage());
		}
		if (!ModuleProperties.getInstance().getUIM()) {
			throw new ExternalStatusException(ModuleProperties.getInstance().getExternalStatusExceptionStatus(), ModuleProperties.getInstance().getExternalStatusExceptionMessage());
		}
		return LocationProperties.getInstance().getLocation();
	}
	@Override
	public int getStatus() throws LocationException {
		Logging.getInstance().putMethod(this, "getStatus");
		if (LocationProperties.getInstance().getLocationException()) {
			throw new LocationException(LocationProperties.getInstance().getLocationExceptionStatus(), LocationProperties.getInstance().getLocationExceptionMessage());
		}
		return status;
	}
	@Override
	public void setProviderLocationStartedListener(ProviderLocationListener listener) {
		Logging.getInstance().putMethod(this, "setProviderLocationStartedListener", listener == null ? null : listener.toString());
		providerListener = listener;
	}
	/**
	 * GPSの即位状態を設定します。（PCSDK固有）
	 * @param status
	 */
	public void setStatus(int status) {
		this.status = status;
	}

	/**
	 * 位置提供を行います。（PCSDK固有）
	 * @param status
	 * @return
	 */
	public Location ProvideLocation(int status) {
		if (status != STATUS_EMERGENCY) {
			return null;
		}
		if (providerListener != null) {
			providerListener.onProvideLocationStarted(status);
		}
		Location location = LocationProperties.getInstance().getLocation();
		Degree latitude = location.getLatitude();
		Degree longitude = location.getLongitude();
		Logging.getInstance().printTerminalMessage("現在位置通知:");
		Logging.getInstance().printTerminalMessage("緯度: " + String.valueOf(latitude.getDegreePart()) + ", " + String.valueOf(latitude.getMinutePart() + ", " + String.valueOf(latitude.getCentisecondPart())));
		Logging.getInstance().printTerminalMessage("経度: " + String.valueOf(longitude.getDegreePart()) + ", " + String.valueOf(longitude.getMinutePart() + ", " + String.valueOf(longitude.getCentisecondPart())));
		return location;
	}

}
