package com.docomo_um.module.location;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import com.docomo_um.lang.Degree;
import com.docomo_um.win.SDKProperties;

public class LocationProperties {
	/** 自身のインスタンス */
	private static LocationProperties locationPropertiesInstance;
	/** 設定ファイルファイル名 */
	private static String filename = "/nano/properties/location.pro";

	/** GPS搭載の有無 */
	private boolean gps = true;
	/** 利用可能な測位方式 */
	private int[] availableMethods;
	/** 利用可能な測位方法 */
	private int[] availableMode;
	/** 測位間隔 */
	private int interval;
	/** 現在位置 */
	private Location location;
	/** LocationExceptionの発生の有無 */
	private boolean locationException = false;
	/** LocationExceptionのステータス */
	private int locationExceptionStatus;
	/** LocationExceptionのメッセージ */
	private String locationExceptionMessage;

	private LocationProperties() {
		// (WGS84): 緯度 35度40分24.85秒(35.67357), 経度 139度44分25.42秒(139.740395)
		Degree latitude = new Degree(35, 40, 2485);
		Degree longitude = new Degree(139, 44, 2542);
		location = new Location(latitude, longitude);
		loadFile();

	}

	public static LocationProperties getInstance() {
		if (locationPropertiesInstance == null) {
			locationPropertiesInstance = new LocationProperties();
		}
		return locationPropertiesInstance;
	}
	/**
	 * LocationExceptionの発生の有無を指定します。
	 * @param enable
	 * @param status
	 * @param message
	 */
	public void setLocationException(boolean enable, int status, String message) {
		locationException = enable;
		locationExceptionStatus = status;
		locationExceptionMessage = message;
	}
	/**
	 * 利用可能な測位方式を取得します。
	 * @return
	 */
	public int[] getAvailableMethods() {
		return availableMethods;
	}

	/**
	 * 設定可能な測位モードを取得します。
	 * @return
	 */
	public int[] getAvailableMode() {
		return availableMode;
	}
	public int getMinimalInterval() {
		return interval;
	}
	/**
	 * 現在位置を取得します。
	 * @return
	 */
	public Location getLocation() {
		return location;
	}
	/**
	 * 現在位置を設定します。
	 * @param location
	 */
	public void setLocation(Location location) {
		this.location = location;
	}
	/**
	 * LocationExceptionの発生の有無を取得します。
	 * @return
	 */
	public boolean getLocationException() {
		return locationException;
	}
	/**
	 * LocationExcepitonのステータスを取得します。
	 * @return
	 */
	public int getLocationExceptionStatus() {
		return locationExceptionStatus;
	}
	/**
	 * LocationExcepitonのメッセージを取得します。
	 * @return
	 */
	public String getLocationExceptionMessage() {
		return locationExceptionMessage;
	}
	/**
	 * GPSの搭載の有無を指定します。
	 * @return
	 */
	public boolean getGPS() {
		return gps;
	}
	private void loadFile() {
		InputStream is;
		try{
			is = new FileInputStream(filename);
		} catch (FileNotFoundException e){

			return;
		}
		SDKProperties pro = new SDKProperties();
		try {
			pro.load(is);
		} catch (IOException e) {
			return;
		}
		String strBuf;
		StringTokenizer token;
		strBuf = pro.getProperty("METHOD");
		if(strBuf != null){
			List<Integer> methods = new ArrayList<Integer>();
			token = new StringTokenizer(strBuf, ",");
			while(token.hasMoreTokens()){
				String str = token.nextToken();
				if (str.equals("AUTO")) {
					methods.add(LocationProvider.METHOD_AUTO);
				}
				else if (str.equals("STANDARD")) {
					methods.add(LocationProvider.METHOD_STANDARD);
				}
				else if (str.equals("STANDALONE")) {
					methods.add(LocationProvider.METHOD_STANDALONE);
				}
			}
			if (methods.size() > 0) {
				availableMethods = new int[methods.size()];
				for (int i = 0; i < methods.size(); i++) {
					availableMethods[i] = methods.get(i);
				}
			}
		}
		strBuf = pro.getProperty("MODE");
		if(strBuf != null){
			List<Integer> mode = new ArrayList<Integer>();
			token = new StringTokenizer(strBuf, ",");
			while(token.hasMoreTokens()){
				String str = token.nextToken();
				if (str.equals("STANDARD")) {
					mode.add(LocationProvider.MODE_STANDARD);
				}
				else if (str.equals("QUALITY")) {
					mode.add(LocationProvider.MODE_QUALITY_PRIORITY);
				}
			}
			if (mode.size() > 0) {
				availableMode = new int[mode.size()];
				for (int i = 0; i < mode.size(); i++) {
					availableMode[i] = mode.get(i);
				}
			}
		}
		strBuf = pro.getProperty("GPS");
		gps = Boolean.valueOf(strBuf);

		strBuf = pro.getProperty("MINIMALINTERVAL");
		if (strBuf != null) {
			interval = Integer.valueOf(strBuf);
		}

		Degree latitude = null;
		Degree longitude = null;
		strBuf = pro.getProperty("LATITUDE");
		if(strBuf != null){
			int degree;
			int minute;
			int centisecond;
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()){
				String str = token.nextToken();
				degree = Integer.valueOf(str);
				if (token.hasMoreTokens()){
					str = token.nextToken();
					minute = Integer.valueOf(str);
					if (token.hasMoreTokens()){
						str = token.nextToken();
						centisecond = Integer.valueOf(str);
						latitude = new Degree(degree, minute, centisecond);
					}
				}
			}
		}
		strBuf = pro.getProperty("LONGITUDE");
		if(strBuf != null){
			int degree;
			int minute;
			int centisecond;
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()){
				String str = token.nextToken();
				degree = Integer.valueOf(str);
				if (token.hasMoreTokens()){
					str = token.nextToken();
					minute = Integer.valueOf(str);
					if (token.hasMoreTokens()){
						str = token.nextToken();
						centisecond = Integer.valueOf(str);
						longitude = new Degree(degree, minute, centisecond);
					}
				}
			}
		}
		if (latitude != null && longitude != null) {
			location = new Location(latitude, longitude);
		}
	}
	/**
	 * 時分秒の有効無効をチェック
	 * @param degree
	 * @param minute
	 * @param centisecond
	 * @return
	 */
	public static boolean availableDegree(int degree, int minute, int centisecond) {
		if (degree < -512 || degree >= 512) {
			return false;
		}
		if (minute < 0 || minute >= 60) {
			return false;
		}
		if (centisecond < 0 || centisecond >= 6000) {
			return false;
		}
		if (degree == -512) {
			if (minute != 0 || centisecond != 0) {
				return false;
			}
		}
		return true;
	}
}
