package com.docomo_um.module.connection;

import java.util.List;

import com.docomo_um.util.ArrayListEx;
import com.docomo_um.win.Logging;

/**
 * シリアルデバイスの情報を表すクラスです。
 *
 * <p>
 * スタートビットやパリティビットなどは固定となります。
 * <ol>
 * <li>スタートビットは「1ビット」固定</li>
 * <li>ストップビットは「1ビット」固定</li>
 * <li>パリティビットは「なし」固定</li>
 * <li>ハードフロー制御は「有り」固定</li>
 * <li>データビットは「8ビット」固定</li>
 * </ol>
 * </p>
 *
 * @see Serial
 * @see SerialConnection
 * @see SerialListener
 */

public final class SerialSpec {
	/** デバイス名 */
	private String name;

	/** 利用可能な通信速度のリスト */
	private List<Long> speedList;

	/** 実シリアルポート名 */
	private String com;

	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 *
	 * @param speed 通信速度を指定します。
	 * @param deviceName デバイス名を指定します。
	 */
	SerialSpec(List<Long> speed, String deviceName, String comPort){
		name = deviceName;
		speedList = speed;
		com = comPort;
	}

	/**
	 * 利用可能な通信速度(bps)のリストを取得します。
	 *
	 * @return 利用可能な通信速度のリストを返します。
	 */
	public List<Long> getCommSpeedList()  {
		Logging.getInstance().putMethod(this, "getCommSpeedList");

		return new ArrayListEx<Long>(speedList);
	}
	/**
	 * シリアルデバイスのデバイス名を取得します。
	 * <p>
	 * デバイス名は「UART01、UART02、UART03、・・・」もしくは「USB01、USB02、USB03、・・・」等のように、「デバイス名(USBもしくはUART)+二桁の数値」という形式で表されます。
	 * </p>
	 * @return デバイス名を返します。
	 */
	public String getDeviceName()  {
		Logging.getInstance().putMethod(this, "getDeviceName");
		return name;
	}

	/**
	 * Windows実シリアルポート名を取得します（PCSDK固有）
	 * @return
	 */
	String getComName() {
		Logging.getInstance().putMethod(this, "getComName");
		return com;
	}
}
