package com.docomo_um.module.connection;

/**
 * SPIの状態変化をイベント通知するリスナクラスです。
 */
public interface SPIListener {


	/**
	 * SPIのCS信号の状態が変化した場合に呼び出されます。
	 *
	 * <p>
	 * CS信号がアクティブになった場合にtrueが設定されます。また、非アクティブになった場合にfalseが設定されます。
	 * </p>
	 *
	 * <p>
	 * <b>留意事項</b><br>
	 * CS信号の変化は高い頻度で通知されます。本メソッドの処理は必要最低限になるように設計してください。
	 *
	 * </p>
	 *
	 * @param device CS信号が変化したSPIデバイスのインスタンスが設定されます。
	 * @param signal CS信号がアクティブになった場合にtrueが設定されます。また、非アクティブになった場合にfalseが設定されます。
	 *
	 */
	public void onChangedStatus(SPIDevice device, boolean signal);
}
