package com.docomo_um.module.connection;

import java.io.IOException;

/**
 * SPIのマスタとスレーブの抽象クラスです。
 */
public abstract class SPIDevice {

	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	SPIDevice() {

	}

	/**
	 *
	 * 連続してデータの送受信を行います。
	 *
	 * @param data 送信データと受信領域の配列を指定します。
	 *
	 * @return 受信したデータを返します。
	 *
	 * @throws IOException 入出力エラーの場合に発生します。
	 * @throws ConnectionException 内部エラーにより処理が中断した場合に発生します。
	 */
	public abstract SPICombinedFormatData[] sendCombinedFormat(SPICombinedFormatData[] data) throws IOException, ConnectionException;
}
