package com.docomo_um.module.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * I2Cマスタ側を表すクラスです。
 * 
 * <p>
 * <b>留意事項</b><br>
 * デバイスと物理的に接続されていない場合、以下の場合に{@link IOException}が発生します。
 * {@link IOException}が発生した場合、そのデバイスとのストリームは自動的にcloseされます。
 * <ul>
 * <li>{@link #getOutputStream()}で取得した出力ストリームで、出力処理を行った場合</li>
 * <li>{@link #getInputStream()}で取得した入力ストリームで、入力処理を行った場合</li>
 * <li>{@link #sendCombinedFormat(byte[], int)}で送信した場合</li>
 * </ul>
 * </p>
 * 
 */
public class I2CMaster extends I2CDevice {

	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 */
	I2CMaster() {

	}


	/**
	 * I2C通信を開始します。
	 */
	public void start() {
		// ignore
	}

	/**
	 * I2C通信を終了します。<br>
	 * 接続先とデータの送受信中に本メソッドをコールした場合は、データの送受信終了後にI2C通信を終了します。<br>
	 * {@link #start()}で通信を開始していない状態の場合、本メソッドは無視されます。
	 * <p>
	 * 通信が終了された際に、オープンされている入出力ストリームが存在する場合、当該ストリームに対して暗黙的にclose()が呼ばれます。
	 * </p>
	 */
	public void stop() {
		// ignore
	}

	/**
	 * 利用する通信速度(bps)を指定します。
	 *
	 * <p>
	 * {@link I2CSpec#getCommSpeedList()}で取得した利用可能な通信速度のリストから、
	 * デバイスに合わせた正しい値を設定してください。
	 * </p>
	 * <p>
	 * インスタンス生成時の初期値は通信モジュールの実装に依存します。
	 * </p>
	 *
	 * @param speed 利用する通信速度(bps)を指定します。
	 * @throws IllegalArgumentException 利用出来ない通信速度(bps)を指定したときに発生します。
	 * @throws IllegalStateException 通信速度を変更できない状態で、本メソッドをコールした場合に発生します。
	 */
	public void setCommSpeed(long speed) {
		// ignore
	}

	/**
	 * 出力ストリームを取得します。
	 *
	 * <p>
	 * {@link #start()}で通信を開始していない状態の場合、{@link IllegalStateException}が発生します。
	 * </p>
	 * <p>
	 * 出力ストリームでデータの出力処理中に{@link IOException}が発生した場合、
	 * 暗黙的にその出力ストリームの{@link OutputStream#close()}がコールされます。
	 * </p>
	 *
	 * @return 出力ストリームを返します。
	 * @throws IllegalStateException {@link #start()}で通信を開始していない状態で、本メソッドをコールした場合に発生します。
	 */
	@Override
	public OutputStream getOutputStream() {
		// ignore
		return null;
	}

	/**
	 * 入力ストリームを取得します。
	 *
	 * <p>
	 * {@link #start()}で通信を開始していない状態の場合、{@link IllegalStateException}が発生します。
	 * </p>
	 * <p>
	 * 入力ストリームでデータの入力処理中に{@link IOException}が発生した場合、
	 * 暗黙的にその入力ストリームの{@link InputStream#close()}がコールされます。
	 * </p>
	 *
	 * @return 入力ストリームを返します。
	 * @throws IllegalStateException {@link #start()}で通信を開始していない状態で、本メソッドをコールした場合に発生します。
	 */
	@Override
	public InputStream getInputStream() {
		// ignore
		return null;
	}

	/**
	 * 書き込みと読み込みを合わせた命令を送信します。
	 *
	 * <p>
	 * 本メソッドは書き込みと読み込みを合わせた複合フォーマットを生成して、マスタからスレーブに対して送信します。
	 * 生成される複合フォーマットは、スレーブに対する書き込みと、スレーブからの読み込みの順番で生成されます。
	 * </p>
	 * <p>
	 * {@link #start()}で通信を開始していない状態の場合、{@link IllegalStateException}が発生します。
	 * </p>
	 *
	 * @param write スレーブに対して送信するデータ を指定します。
	 * @param bufferSize スレーブから受信したデータの格納先バッファのサイズを指定します。
	 * @return スレーブから読み込んだ結果が格納されたバッファを返します。
	 * @throws NullPointerException writeがnullの場合に発生します。
	 * @throws IllegalArgumentException bufferSizeが負数、または0の場合に発生します。
	 * @throws IllegalStateException {@link #start()}で通信を開始していない状態で、本メソッドをコールした場合に発生します。
	 * @throws IOException 入出力エラーの場合に発生します。
	 */
	public byte[] sendCombinedFormat(byte[] write, int bufferSize) throws IOException {
		// ignore
		return null;
	}

}
