package com.docomo_um.module.connection;

import java.util.ArrayList;
import java.util.List;

public class GPIOFunctions {
	/** リスナ */
	private static GPIOListener gpiolistener = null;
	/** 監視対象入力ポートリスト */
	private static List<Integer> inquiryPorts;
	/** 入力ポートリスト */
	private static List<Integer> inPortList;
	/** 出力ポートリスト */
	private static List<Integer> outPortList;
	/** 入力ポート値 */
	private static boolean[] inPort;
	/** 出力ポート値 */
	private static boolean[] outPort;

	static void InitGPIOFunctions(List<Integer> in, List<Integer> out) {
		inPortList = in;
		outPortList = out;
		inPort = new boolean[inPortList.size()];
		outPort = new boolean[outPortList.size()];
		inquiryPorts = new ArrayList<Integer>();
	}

	public static List<Integer> getAvailableInPort() {
		List<Integer> list = new ArrayList<Integer>();
		for (int i = 0; i < inPortList.size(); i++) {
			list.add(inPortList.get(i));
		}
		return list;
	}
	public static List<Integer> getAvailableOutPort(){
		List<Integer> list = new ArrayList<Integer>();
		for (int i = 0; i < outPortList.size(); i++) {
			list.add(outPortList.get(i));
		}
		return list;
	}
	public static void setGPIOListener(List<Integer> inquiry, GPIOListener listener) throws ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		if (inquiry.size() == 0) {
			throw new IllegalArgumentException();
		}
		inquiryPorts.clear();
		for (int i = 0; i < inquiry.size(); i++) {
			int port = inquiry.get(i);
			if (!inPortList.contains(port)) {
				throw new IllegalArgumentException();
			}
			inquiryPorts.add(port);
		}
		gpiolistener = listener;

	}
	public static void sendControlSignal(int out, boolean signal) throws ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		int index = outPortList.indexOf(out);
		if (index < 0) {
			throw new IllegalArgumentException();
		}
		outPort[index] = signal;

	}

	public static boolean receiveControlSignal(int in) throws ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		int index = inPortList.indexOf(in);
		if (index < 0) {
			throw new IllegalArgumentException();
		}
		return inPort[index];
	}

	public static boolean getControlSignal(int out) throws ConnectionException {
		if (ConnectionProperties.getInstance().getConnectionException()) {
			throw new ConnectionException(ConnectionProperties.getInstance().getConnectionExceptionMessage());
		}
		int index = outPortList.indexOf(out);
		if (index < 0) {
			throw new IllegalArgumentException();
		}
		return outPort[index];
	}

	public static void setReceiveControlSignal(int in, boolean signal) {
		int index = inPortList.indexOf(in);
		if (index < 0) {
			throw new IllegalArgumentException();
		}
		if (inPort[index] == signal)
			return;

		inPort[index] = signal;
		index = inquiryPorts.indexOf(in);
		if (index >= 0 && gpiolistener != null) {
			gpiolistener.onChangedStatus(in, signal);
		}
	}
}
