package com.docomo_um.module.connection;

import com.docomo_um.win.Logging;

/**
 * 有線通信IFの処理に失敗した場合に発生する例外クラスです。
 */
public class ConnectionException extends Exception {

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。 
	 */
	public ConnectionException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。 
	 * @param msg 詳細メッセージを指定します。
	 */
	public ConnectionException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "ConnectionException", msg);
	}
}
