package com.docomo_um.module.connection;

import java.util.List;

import com.docomo_um.win.Logging;

/**
 * ADコンバータを表すクラスです。
 * <p>
 * チャンネルリストを取得するには、{@link #getADChannelList()}を使用します。
 * いずれかのチャンネルのAD変換値を取得するには、{@link #getAD(ADChannel ch)}を使用します。
 * </p>
 * 
 * <p>
 * <b>留意事項</b><br>
 * デバイスの故障などによる障害が発生した場合、または物理的に接続されていない場合、以下のメソッドをコールしても例外は発生しません。
 * <ul>
 * <li>{@link #getAD(ADChannel)}</li>
 * </ul>
 * そのような場合において、このクラスの各メソッドがどのような値を返すのかは、通信モジュールの実装に依存します。
 * </p>
 * 
 * @see ADChannel
 */
public class ADConverter implements Connectable {
	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 *
	 * @param chList チャンネルリストを指定します。
	 */
	ADConverter(List <ADChannel> chList){
		ADConverterFunctions.initADConverter(chList);
	}

	/**
	 * チャンネルリストを取得します。
	 *
	 * @return チャンネルリストを返します。
	 */
	public List <ADChannel> getADChannelList() {
		Logging.getInstance().putMethod(this, "getADChannelList");
		return ADConverterFunctions.getChannelList();
	}

	/**
	 * AD変換値を取得します。
	 *
	 * @param ch チャンネルを指定します。
	 * @return AD変換値を返します。
	 * @throws NullPointerException chにnullを指定した場合に発生します。
	 * @throws ConnectionException 内部エラーにより処理が中断した場合に発生します。
	 */
	public int getAD(ADChannel ch) throws ConnectionException {
		Logging.getInstance().putMethod(this, "ADChannel", ch.toString());
		return ADConverterFunctions.getAD(ch);
	}
}
