package com.docomo_um.module.connection;

import com.docomo_um.win.Logging;

/**
 * ADコンバータのチャンネルを表すクラスです。
 * @see ADConverter
 */
public final class ADChannel {
	/** チャネル名 */
	private String name;
	/** 解像度 */
	private int resolution;
	/**
	 * アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 *
	 * @param chName チャンネル名を指定します。
	 * @param resolution 解像度を指定します。
	 */
	ADChannel(String chName, int resolution){
		name = chName;
		this.resolution = resolution;
	}

	/**
	 * チャンネル名を取得します。
	 *
	 * @return チャンネル名を返します。
	 */
	public String getChannelName(){
		Logging.getInstance().putMethod(this, "getChannelName");
		return name;
	}

	/**
	 * 解像度(bit)を取得します。
	 *
	 * @return 解像度を返します。
	 */
	public int getResolution() {
		Logging.getInstance().putMethod(this, "getResolution");
		return resolution;
	}

}
