package com.docomo_um.module;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import com.docomo_um.win.SDKProperties;

/**
 * モジュール関連プロパティクラス（PCSDK固有）
 *
 */
public class ModuleProperties {
	private static ModuleProperties instanceModuleProperties = null;
	private static String filename = "/nano/properties/module.pro";

	// com.docomo_um.module関連
	private static List<Application> applicationList;	// アプリケーション情報
	private static int areaInfo;						// エリア状態のデフォルト値
	private static int signalStatus;					// アンテナ状態のデフォルト値
	private static String IMEI;							// IMEI(International Mobile Equipment Identity)
	private static String IMEISV;						// IMEISV(International Mobile Equipment Identity Software Version)
	private static String moduleVersion;				// 本モジュールのバージョン
	private static int recievedPower;					// 受信する電波の受信電力指標
	private static int regulation;						// 通信規制状態
	private static String teleNumber;					// 電話番号
	private static String ICCID;						// ICCID
	private static String PIN1Code;						// PIN1コード
	private static String UnlockCode;					// PIN1ロック解除コード
	private static boolean PIN1Enable;					// PIN1有効
	private static int PIN1LockCount;					// PIN1ロックカウント
	private static int PIN1FullLockCount;				// PIN1フルロックカウント
	private static boolean UIM;							// UIM挿入有無
	private static int systemUpdateStatus;				// システムアップデート状態
	private static boolean cancelSystemUpdate = true;	// システムアップデートのキャンセルの可否
	private static boolean moduleException;				// ModuleExceptionの発生の有無を指定
	private static String moduleExceptionMessage; 		// ModuleExceptionのメッセージ
	private static boolean communicationFailureException; // CommunicationFailureException発生の有無を指定
	private static int communicationFailureExceptionStatus; // CommunicationFailureExceptionのステータス
	private static String communicationFailureExceptionMessage; // CommunicationFailureExceptionのメッセージ
	private static boolean deviceException;				// DeviceExceptionの発生の有無を指定
	private static String deviceExceptionMessage; 		// DeviceExceptionのメッセージ
	private static boolean externalStatusException;		// ExternalStatusExceptionの発生の有無を指定
	private static int externalStatusExceptionStatus;
	private static String externalStatusExceptionMessage;	// ExternalStatusExceptionのメッセージ
	private static boolean illegalSettingException;		// IllegalSettingExceptionの発生の有無を指定
	private static String illegalSettingExceptionMessage;	// IllegalSettingExceptionのメッセージ
	private static boolean regulationException; 		// RegulationExceptionの発生の有無を指定
	private static String regulationExceptionMessage; 	// RegulationExceptionのメッセージ
	private static boolean timerException;				// TimerExceptionの発生の有無を指定
	private static String timerExceptionMessage;		// TimerExceptionのメッセージ
	/**
	 * モジュール情報プロパティのインスタンスを取得
	 *
	 * @return モジュール情報プロパティのインスタンス
	 */
	public static ModuleProperties getInstance(){
		if(instanceModuleProperties == null){
			instanceModuleProperties = new ModuleProperties();
		}
		return instanceModuleProperties;
	}

	/**
	 * アプリケーション情報のリストを取得
	 * @return アプリケーション情報
	 */
	public List<Application> getApplicationList() {
		return applicationList;
	}

	/**
	 * 現在のエリア状態を変更
	 * @param info	エリア状態
	 */
	public void setAreaInfo(int info){
		areaInfo = info;
	}

	/**
	 * 現在のエリア状態を取得
	 * @return エリア状態
	 */
	public int getAreaInfo() {
		return areaInfo;
	}

	/**
	 * 現在のアンテナ状態を変更
	 * @param status	アンテナ状態
	 */
	public void setSignalStatus(int status){
		signalStatus = status;
	}

	/**
	 * 現在のアンテナ状態を
	 * @return
	 */
	public int getSignalStatus(){
		return signalStatus;
	}

	/**
	 * IMEIの取得
	 * @return
	 */
	public String getIMEI(){
		return IMEI;
	}

	/**
	 * IMEISVの取得
	 * @return
	 */
	public String getIMEISV(){
		return IMEISV;
	}

	/**
	 * モジュールバージョンの取得
	 * @return
	 */
	public String getModuleVersion(){
		return moduleVersion;
	}

	/**
	 * 受信電力指標を変更
	 * @param power
	 */
	public void setRecievedPower(int power){
		recievedPower = power;
	}

	/**
	 * 受信電力指標を取得
	 * @return
	 */
	public int getRecievedPower(){
		return recievedPower;
	}

	/**
	 * 現在の通信規制状態を変更
	 * @param reg
	 */
	public void setRegulation(int reg){
		regulation = reg;
	}

	/**
	 * 現在の通信規制状態を変更
	 * @return
	 */
	public int getRegulation(){
		return regulation;
	}

	/**
	 * 電話番号を取得
	 * @return
	 */
	public String getTeleNumber(){
		return teleNumber;
	}

	/**
	 * UICC番号を取得
	 * @return
	 */
	public String getICCID(){
		return ICCID;
	}

	/**
	 * PIN1コードを変更
	 * @param status
	 */
	public void setPIN1Code(String status){
		PIN1Code = status;
	}

	/**
	 * PIN1コードを取得
	 * @return
	 */
	public String getPIN1Code(){
		return PIN1Code;
	}

	/**
	 * PIN1ロック解除コードを変更
	 * @param status
	 */
	public void setUnlockCode(String status){
		UnlockCode = status;
	}

	/**
	 * PIN1ロック解除コードを取得
	 * @return
	 */
	public String getUnlockCode(){
		return UnlockCode;
	}

	/**
	 * PIN1有効状態を変更
	 * @param status
	 */
	public void setPIN1Enable(boolean status){
		PIN1Enable = status;
	}

	/**
	 * PIN1有効状態を取得
	 * @return
	 */
	public boolean getPIN1Enable(){
		return PIN1Enable;
	}

	/**
	 * UIM挿入状態を取得
	 * @return
	 */
	public boolean getUIM(){
		return UIM;
	}
	/**
	 * UIM挿入状態を変更
	 * @param enable
	 */
	public void setUIM(boolean enable) {
		UIM = enable;
	}
	/**
	 * PIN1ロックカウントを取得
	 * @return
	 */
	public int getPIN1LockCount() {
		return PIN1LockCount;
	}
	/**
	 * PIN1フルロックカウントを取得
	 * @return
	 */
	public int getPIN1FullLockCount() {
		return PIN1FullLockCount;
	}
	/**
	 * システムアップデート状態を変更
	 * @param status
	 */
	public void setSystemUpdateStatus(int status){
		systemUpdateStatus = status;
	}
	/**
	 * 現在のシステムアップデート状態を取得
	 * @return
	 */
	public int getSystemUpdateStatus()
	{
		return systemUpdateStatus;
	}
	/**
	 * システムアップデートのキャンセルの可否を指定します
	 * @param enable
	 */
	public void setCancelSystemUpdate(boolean enable) {
		cancelSystemUpdate = enable;
	}
	/**
	 * システムアップデートのキャンセルの可否を取得します
	 * @return
	 */
	public boolean getCancelSystemUpdate() {
		return cancelSystemUpdate;
	}
	/**
	 * ModuleExceptionの発生の有無を設定
	 * @param enable
	 */
	public void setModuleException(boolean enable) {
		moduleException = enable;
	}

	public void setModuleException(boolean enable, String message) {
		moduleException = enable;
		moduleExceptionMessage = message;
	}
	/**
	 * ModuleExceptionの発生の有無を取得
	 * @return
	 */
	public boolean getModuleException() {
		return moduleException;
	}

	public String getModuleExceptionMessage() {
		return moduleExceptionMessage;
	}
	/**
	 * CommunicationFailureExceptionの発生の有無を設定
	 * @param enable
	 */
	public void setCommunicationFailureException(boolean enable) {
		communicationFailureException = enable;
	}
	public void setCommunicationFailureException(boolean enable, int status) {
		communicationFailureException = enable;
		communicationFailureExceptionStatus = status;
	}
	public void setCommunicationFailureException(boolean enable, int status, String message) {
		communicationFailureException = enable;
		communicationFailureExceptionStatus = status;
		communicationFailureExceptionMessage = message;
	}
	/**
	 * CommunicationFailureExceptionの発生の有無を取得
	 * @param enable
	 */
	public boolean getCommunicationFailureException() {
		return communicationFailureException;
	}
	public int getCommunicationFailureExceptionStatus() {
		return communicationFailureExceptionStatus;
	}
	public String getCommunicationFailureExceptionMessage() {
		return communicationFailureExceptionMessage;
	}
	/**
	 * DeviceExceptionの発生の有無を設定
	 * @param enable
	 */
	public void setDeviceException(boolean enable) {
		deviceException = enable;
	}
	public void setDeviceException(boolean enable, String message) {
		deviceException = enable;
		deviceExceptionMessage = message;
	}
	/**
	 * DeviceExceptionの発生の有無を取得
	 * @return
	 */
	public boolean getDeviceException() {
		return deviceException;
	}
	public String getDeviceExceptionMessage() {
		return deviceExceptionMessage;
	}

	/**
	 * ExternalStatusExceptionの発生の有無を設定
	 * @param enable
	 */
	public void setExternalStatusException(boolean enable) {
		externalStatusException = enable;
	}
	public void setExternalStatusException(boolean enable, int status, String message) {
		externalStatusException = enable;
		externalStatusExceptionStatus = status;
		externalStatusExceptionMessage = message;
	}
	/**
	 * ExternalStatusExcepitonの発生の有無を取得
	 * @return
	 */
	public boolean getExternalStatusException() {
		return externalStatusException;
	}
	public int getExternalStatusExceptionStatus() {
		return externalStatusExceptionStatus;
	}
	public String getExternalStatusExceptionMessage() {
		return externalStatusExceptionMessage;
	}

	/**
	 * IllegalSettingExceptionの発生の有無を設定
	 * @param enable
	 */
	public void setIllegalSettingException(boolean enable) {
		illegalSettingException = enable;
	}
	public void setIllegalSettingException(boolean enable, String message) {
		illegalSettingException = enable;
		illegalSettingExceptionMessage = message;
	}
	/**
	 * IllegalSettingExceptionの発生の有無を取得
	 * @return
	 */
	public boolean getIllegalSettingException() {
		return illegalSettingException;
	}
	public String getIllegalSettingExceptionMesswage() {
		return illegalSettingExceptionMessage;
	}

	/**
	 * RegulationExceptionの発生の有無を設定
	 * @param enable
	 */
	public void setRegulationException(boolean enable) {
		regulationException = enable;
	}
	public void setRegulationException(boolean enable, String message) {
		regulationException = enable;
		regulationExceptionMessage = message;
	}
	/**
	 * RegulationExceptionの発生の有無を取得
	 * @return
	 */
	public boolean getRegulationException() {
		return regulationException;
	}
	public String getRegulationExceptionMessage() {
		return regulationExceptionMessage;
	}
	/**
	 * TimerExceptionの発生の有無を設定
	 * @param enable
	 * @param message
	 */
	public void setTimerExcepiton(boolean enable, String message) {
		timerException = enable;
		timerExceptionMessage = message;
	}
	public boolean getTimerException() {
		return timerException;
	}
	public String getTimerExcepiotnMessage() {
		return timerExceptionMessage;
	}
	/**
	 * コンストラクタ
	 */
	private ModuleProperties(){
		applicationList = new ArrayList<Application>();
		areaInfo = ModuleInfo.AREA_INFO_OUTSIDE;
		signalStatus = ModuleInfo.SIGNAL_STATUS_OUTSIDE;
		IMEI = new String();
		IMEISV = new String();
		moduleVersion = new String();
		recievedPower = 0;
		regulation = ModuleInfo.REGULATION_NONE;
		teleNumber = new String();
		ICCID = new String();
		PIN1Code = new String();
		UnlockCode = new String();
		systemUpdateStatus = ModuleManager.SYSTEM_UPDATE_IDLE;
		PIN1Enable = false;
		UIM = false;

		try{
			this.getFileProperties();
		} catch (IOException e){
			e.printStackTrace();
		}
	}

	/**
	 * ファイルからプロパティを取得
	 */
	private void getFileProperties() throws IOException{
		InputStream is;
		String name;
		String strBuf = null;
		StringTokenizer token;

		try{
			is = new FileInputStream(filename);
		} catch (FileNotFoundException e){

			return;
		}
		SDKProperties pro = new SDKProperties();
		pro.load(is);

		//APPLICATION
		for (int i = 1; i < 10; i++){
			name = "APPLICATION" + String.valueOf(i);
			strBuf = pro.getProperty(name);
			if (strBuf != null){
				token = new StringTokenizer(strBuf, ",");
				String appName = token.nextToken();
				String appArea = token.nextToken();
				Application app = new Application(appName, appArea);
				applicationList.add(app);
			}
		}

		//AREAINFO
		strBuf = pro.getProperty("AREAINFO");
		if(strBuf != null){
			token = new StringTokenizer(strBuf, ",");
			while(token.hasMoreTokens()){
				String str = token.nextToken();
				if(str.equals("FOMA")){
					areaInfo |= ModuleInfo.AREA_INFO_FOMA;
				}
				else if(str.equals("HSDPA")){
					areaInfo |= ModuleInfo.AREA_INFO_HSDPA;
				}
				else if(str.equals("HSUPA")){
					areaInfo |= ModuleInfo.AREA_INFO_HSUPA;
				}
			}
		}

		// SIGNALSTATUS
		strBuf = pro.getProperty("SIGNALSTATUS");
		signalStatus = Integer.valueOf(strBuf);
		if(signalStatus<ModuleInfo.SIGNAL_STATUS_OUTSIDE){
			signalStatus = ModuleInfo.SIGNAL_STATUS_OUTSIDE;
		}
		else if(signalStatus > ModuleInfo.SIGNAL_STATUS_LEVEL3){
			signalStatus = ModuleInfo.SIGNAL_STATUS_LEVEL3;
		}

		// IMEI
		IMEI = pro.getProperty("IMEI");

		// IMEISV
		IMEISV = pro.getProperty("IMEISV");

		// MODULEVER
		moduleVersion = pro.getProperty("MODULEVER");

		// RECVPOWER
		recievedPower = Integer.valueOf(pro.getProperty("RECVPOWER"));
		if(recievedPower < 0){
			recievedPower = 0;
		}
		else if(recievedPower > 75){
			recievedPower = 75;
		}

		// REGULATION
		regulation = ModuleInfo.REGULATION_NONE;
		strBuf = pro.getProperty("REGULATION");
		if(strBuf != null){
			token = new StringTokenizer(strBuf, ",");
			while(token.hasMoreTokens()){
				String str = token.nextToken();
				if(str.equals("PACKET")){
					regulation |= ModuleInfo.REGULATION_PACKET;
				}
				else if(str.equals("VOICE")){
					regulation |= ModuleInfo.REGULATION_VOICE;
				}
			}
		}

		// TELENUMBER
		teleNumber = pro.getProperty("TELENUMBER");

		// UICC
		ICCID = pro.getProperty("ICCID");

		// PIN1CODE
		PIN1Code = pro.getProperty("PIN1CODE", "");

		// UNLOCKCODE
		UnlockCode = pro.getProperty("UNLOCKCODE", "");

		// ENABLEPIN1
		strBuf = pro.getProperty("PIN1ENABLE", "FALSE");
		PIN1Enable = Boolean.valueOf(strBuf);

		// INUIM
		strBuf = pro.getProperty("UIM", "FALSE");
		UIM = Boolean.valueOf(strBuf);

		strBuf = pro.getProperty("PIN1LOCKCOUNT", "0");
		PIN1LockCount = Integer.valueOf(strBuf);

		strBuf = pro.getProperty("PIN1FULLLOCKCOUNT", "0");
		PIN1FullLockCount = Integer.valueOf(strBuf);

		// MODULEEXCEPTION
		moduleException = false;
		moduleExceptionMessage = "";
		strBuf = pro.getProperty("MODULEEXCEPTION");
		if (strBuf != null) {
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()) {
				moduleException = Boolean.valueOf(token.nextToken());
				while (token.hasMoreTokens()) {
					moduleExceptionMessage += token.nextToken();
					if (token.hasMoreTokens()) {
						moduleExceptionMessage += " ";
					}
				}
			}
		}
		// COMMUNICATIONFAILUREEXCEPTION
		communicationFailureException = false;
		communicationFailureExceptionStatus = 1;
		communicationFailureExceptionMessage = "";
		strBuf = pro.getProperty("COMMUNICATIONFAILUREEXCEPTION");
		if (strBuf != null) {
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()) {
				communicationFailureException = Boolean.valueOf(token.nextToken());
				if (token.hasMoreTokens()) {
					communicationFailureExceptionStatus = Integer.valueOf(token.nextToken());
					while (token.hasMoreTokens()) {
						communicationFailureExceptionMessage += token.nextToken();
						if (token.hasMoreTokens()) {
							communicationFailureExceptionMessage += " ";
						}
					}
				}
			}
		}
		// DEVICEEXCEPTION
		deviceException = false;
		deviceExceptionMessage = "";
		strBuf = pro.getProperty("DEVICEEXCEPTION");
		if (strBuf != null) {
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()) {
				moduleException = Boolean.valueOf(token.nextToken());
				while (token.hasMoreTokens()) {
					moduleExceptionMessage += token.nextToken();
					if (token.hasMoreTokens()) {
						moduleExceptionMessage += " ";
					}
				}
			}
		}
		// EXTERNALSTATUSEXCEPTION
		externalStatusException = false;
		externalStatusExceptionMessage = "";
		strBuf = pro.getProperty("EXTERNALSTATUSEXCEPTION");
		if (strBuf != null) {
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()) {
				externalStatusException = Boolean.valueOf(token.nextToken());
				while (token.hasMoreTokens()) {
					externalStatusExceptionMessage += token.nextToken();
					if (token.hasMoreTokens()) {
						externalStatusExceptionMessage += " ";
					}
				}
			}
		}
		// ILLEGALSETTINGEXCEPTION
		illegalSettingException = false;
		illegalSettingExceptionMessage = "";
		strBuf = pro.getProperty("ILLEGALSETTINGEXCEPTION");
		if (strBuf != null) {
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()) {
				illegalSettingException = Boolean.valueOf(token.nextToken());
				while (token.hasMoreTokens()) {
					illegalSettingExceptionMessage += token.nextToken();
					if (token.hasMoreTokens()) {
						illegalSettingExceptionMessage += " ";
					}
				}
			}
		}
		// REGULATIONEXCEPTION
		regulationException = false;
		regulationExceptionMessage = "";
		strBuf = pro.getProperty("ILLEGALSETTINGEXCEPTION");
		if (strBuf != null) {
			token = new StringTokenizer(strBuf, ",");
			if (token.hasMoreTokens()) {
				regulationException = Boolean.valueOf(token.nextToken());
				while (token.hasMoreTokens()) {
					regulationExceptionMessage += token.nextToken();
					if (token.hasMoreTokens()) {
						regulationExceptionMessage += " ";
					}
				}
			}
		}
	}
}
