package com.docomo_um.module;


public class ModuleFunctions {
	/** モジュールリスナ */
	private static ModuleListener moduleListener = null;
	public static void setModuleListener(ModuleListener listener) {
		moduleListener = listener;
	}
	/*
	 * ターミナルからのシステムアップデート要求（PCSDK固有）
	 */
	public static void requestSystemUpdate(){
		if (moduleListener != null) {
			moduleListener.onSystemUpdate();
		}
	}
	/*
	 * ターミナルからのシステムアップデート中断要求（PCSDK固有）
	 */
	public static void requestSystemUpdateAbort(int status) {
		if (moduleListener != null) {
			moduleListener.onSystemUpdateAbort(status);
		}
	}
	/*
	 * ターミナルからのシステムリセット要求（PCSDK固有）
	 */
	public static void requestReset() {
		if (ModuleProperties.getInstance().getSystemUpdateStatus() == ModuleManager.SYSTEM_UPDATE_DOWNLOADING) {
			ModuleProperties.getInstance().setSystemUpdateStatus(ModuleManager.SYSTEM_UPDATE_DOWNLOAD_COMPLETE);
		}
		if (moduleListener != null) {
			moduleListener.onReset();
		}
	}

}
