package com.docomo_um.module;

import com.docomo_um.win.Logging;

/**
 * モジュールの内部ソフトウェアの動作が原因で発生する例外クラスです。
 */
public class ModuleException extends Exception {

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。
	 */
	public ModuleException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。
	 *
	 * @param msg 詳細メッセージを指定します。
	 */
	public ModuleException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "ModuleException", msg);
	}

}
