package com.docomo_um.module;

import com.docomo_um.win.Logging;

/**
 * プログラムから設定される情報の不備、もしくは不正が原因で発生する例外クラスです。
 */
public class IllegalSettingException extends Exception {

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。
	 */
	public IllegalSettingException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。
	 *
	 * @param msg 詳細メッセージを指定します。
	 */
	public IllegalSettingException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "IllegalSettingException", msg);
	}
}
