package com.docomo_um.module;

import com.docomo_um.win.Logging;

/**
 * 内蔵デバイスの故障が原因で発生する例外クラスです。
 */
public class DeviceException extends Exception {

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。
	 */
	public DeviceException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。
	 *
	 * @param msg 詳細メッセージを指定します。
	 */
	public DeviceException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "DeviceException", msg == null ? "null" : msg);
	}
}
