package com.docomo_um.module;

import com.docomo_um.win.Logging;

/**
 * 通信の失敗が原因で発生する例外クラスです。
 * 
 * <p>
 * 
 * </p>
 * <p>
 * 音声呼に対する例外は以下のcause値(TS24.008 10.5.4.11)を返却します。<br>
 * <table class="cause">
 * <tr><th>Cause値</th><th>内容</th></tr>
 * <tr><td>1</td><td>Unassigned (unallocated) number</td></tr>
 * <tr><td>3</td><td>No route to destination</td></tr>
 * <tr><td>6</td><td>Channel unacceptable</td></tr>
 * <tr><td>8</td><td>Operator determined barring</td></tr>
 * <tr><td>16</td><td>Normal call clearing</td></tr>
 * <tr><td>17</td><td>User busy</td></tr>
 * <tr><td>18</td><td>No user responding</td></tr>
 * <tr><td>19</td><td>User alerting, no answer</td></tr>
 * <tr><td>21</td><td>Call rejected</td></tr>
 * <tr><td>22</td><td>Number changed</td></tr>
 * <tr><td>24</td><td>Call rejected due to feature at the destination</td></tr>
 * <tr><td>25</td><td>Pre-emption</td></tr>
 * <tr><td>26</td><td>Non selected user clearing</td></tr>
 * <tr><td>27</td><td>Destination out of order</td></tr>
 * <tr><td>28</td><td>Invalid number format (incomplete number)</td></tr>
 * <tr><td>29</td><td>Facility rejected</td></tr>
 * <tr><td>30</td><td>Response to STATUS ENQUIRY</td></tr>
 * <tr><td>31</td><td>Normal, unspecified</td></tr>
 * <tr><td>34</td><td>No circuit/channel available</td></tr>
 * <tr><td>38</td><td>Network out of order</td></tr>
 * <tr><td>41</td><td>Temporary failure</td></tr>
 * <tr><td>42</td><td>Switching equipment congestion</td></tr>
 * <tr><td>43</td><td>Access information discarded</td></tr>
 * <tr><td>44</td><td>requested circuit/channel not available</td></tr>
 * <tr><td>47</td><td>Resources unavailable, unspecified</td></tr>
 * <tr><td>49</td><td>Quality of service unavailable</td></tr>
 * <tr><td>50</td><td>Requested facility not subscribed</td></tr>
 * <tr><td>55</td><td>Incoming calls barred within the CUG</td></tr>
 * <tr><td>57</td><td>Bearer capability not authorized</td></tr>
 * <tr><td>58</td><td>Bearer capability not presently available</td></tr>
 * <tr><td>63</td><td>Service or option not available, unspecified</td></tr>
 * <tr><td>65</td><td>Bearer service not implemented</td></tr>
 * <tr><td>68</td><td>ACM equal to or greater than ACMmax</td></tr>
 * <tr><td>69</td><td>Requested facility not implemented</td></tr>
 * <tr><td>70</td><td>Only restricted digital information bearer capability is available</td></tr>
 * <tr><td>79</td><td>Service or option not implemented, unspecified</td></tr>
 * <tr><td>81</td><td>Invalid transaction identifier value</td></tr>
 * <tr><td>87</td><td>User not member of CUG</td></tr>
 * <tr><td>88</td><td>Incompatible destination</td></tr>
 * <tr><td>91</td><td>Invalid transit network selection</td></tr>
 * <tr><td>95</td><td>Semantically incorrect message</td></tr>
 * <tr><td>96</td><td>Invalid mandatory information</td></tr>
 * <tr><td>97</td><td>Message type non-existent or not implemented</td></tr>
 * <tr><td>98</td><td>Message type not compatible with protocol state</td></tr>
 * <tr><td>99</td><td>Information element non-existent or not implemented</td></tr>
 * <tr><td>100</td><td>Conditional IE error</td></tr>
 * <tr><td>101</td><td>Message not compatible with protocol state</td></tr>
 * <tr><td>102</td><td>Recovery on timer expiry</td></tr>
 * <tr><td>111</td><td>Protocol error, unspecified</td></tr>
 * <tr><td>127</td><td>Interworking, unspecified</td></tr>
 * </table>
 * </p>
 * <p>
 * パケット呼に対する例外は以下のSM-Cause値(TS24.008 10.5.6.6)を返却します。<br>
 * <table class="cause">
 * <tr><th>Cause値</th><th>内容</th></tr>
 * <tr><td>8</td><td>Operator Determined Barring</td></tr>
 * <tr><td>24</td><td>MBMS bearer capabilities insufficient for the service</td></tr>
 * <tr><td>25</td><td>LLC or SNDCP failure(A/Gb mode only)</td></tr>
 * <tr><td>26</td><td>Insufficient resources</td></tr>
 * <tr><td>27</td><td>Missing or unknown APN</td></tr>
 * <tr><td>28</td><td>Unknown PDP address or PDP type</td></tr>
 * <tr><td>29</td><td>User authentication failed</td></tr>
 * <tr><td>30</td><td>Activation rejected by GGSN, Serving GW or PDN GW</td></tr>
 * <tr><td>31</td><td>Activation rejected, unspecified</td></tr>
 * <tr><td>32</td><td>Service option not supported</td></tr>
 * <tr><td>33</td><td>Requested service option not subscribed</td></tr>
 * <tr><td>34</td><td>Service option temporarily out of order</td></tr>
 * <tr><td>35</td><td>NSAPI already used (not sent)</td></tr>
 * <tr><td>36</td><td>Regular deactivation</td></tr>
 * <tr><td>37</td><td>QoS not accepted</td></tr>
 * <tr><td>38</td><td>Network failure</td></tr>
 * <tr><td>39</td><td>Reactivation requested</td></tr>
 * <tr><td>40</td><td>Feature not supported</td></tr>
 * <tr><td>41</td><td>Semantic error in the TFT operation</td></tr>
 * <tr><td>42</td><td>Syntactical error in the TFT operation</td></tr>
 * <tr><td>43</td><td>Unknown PDP context</td></tr>
 * <tr><td>44</td><td>Semantic errors in packet filter(s)</td></tr>
 * <tr><td>45</td><td>Syntactical errors in packet filter(s)</td></tr>
 * <tr><td>46</td><td>PDP context without TFT already activated </td></tr>
 * <tr><td>47</td><td>Multicast group membership time-out </td></tr>
 * <tr><td>48</td><td>Request rejected, BCM violation</td></tr>
 * <tr><td>50</td><td>PDP type IPv4 only allowed</td></tr>
 * <tr><td>51</td><td>PDP type IPv6 only allowed</td></tr>
 * <tr><td>52</td><td>Single address bearers only allowed</td></tr>
 * <tr><td>56</td><td>Collision with network initiated request</td></tr>
 * <tr><td>60</td><td>Bearer handling not supported</td></tr>
 * <tr><td>81</td><td>Invalid transaction identifier value</td></tr>
 * <tr><td>95</td><td>Semantically incorrect message</td></tr>
 * <tr><td>96</td><td>Invalid mandatory information</td></tr>
 * <tr><td>97</td><td>Message type non-existent or not implemented</td></tr>
 * <tr><td>98</td><td>Message type not compatible with the protocol state</td></tr>
 * <tr><td>99</td><td>Information element non-existent or not implemented</td></tr>
 * <tr><td>100</td><td>Conditional IE error</td></tr>
 * <tr><td>101</td><td>Message not compatible with the protocol state</td></tr>
 * <tr><td>111</td><td>Protocol error, unspecified</td></tr>
 * <tr><td>112</td><td>APN restriction value incompatible with active PDP context</td></tr>
 * </table>
 * </p>
 * <p>
 * SMSに対する例外は以下のRP-Cause値(TS24.011 8.2.5.4)を返却します。<br>
 * <table class="cause">
 * <tr><th>Cause値</th><th>内容</th></tr>
 * <tr><td>1</td><td>Unassigned (unallocated) number</td></tr>
 * <tr><td>8</td><td>Operator determined barring</td></tr>
 * <tr><td>10</td><td>Call barred</td></tr>
 * <tr><td>11</td><td>Reserved</td></tr>
 * <tr><td>21</td><td>Short message transfer rejected</td></tr>
 * <tr><td>22</td><td>Memory capacity exceeded</td></tr>
 * <tr><td>27</td><td>Destination out of order</td></tr>
 * <tr><td>28</td><td>Unidentified subscriber</td></tr>
 * <tr><td>29</td><td>Facility rejected</td></tr>
 * <tr><td>30</td><td>Unknown subscriber</td></tr>
 * <tr><td>38</td><td>Network out of order</td></tr>
 * <tr><td>41</td><td>Temporary failure</td></tr>
 * <tr><td>42</td><td>Congestion</td></tr>
 * <tr><td>47</td><td>Resources unavailable, unspecified</td></tr>
 * <tr><td>50</td><td>Requested facility not subscribed</td></tr>
 * <tr><td>69</td><td>Requested facility not implemented</td></tr>
 * <tr><td>81</td><td>Invalid short message transfer reference value</td></tr>
 * <tr><td>95</td><td>Semantically incorrect message</td></tr>
 * <tr><td>96</td><td>Invalid mandatory information</td></tr>
 * <tr><td>97</td><td>Message type nonexistent or not implemented</td></tr>
 * <tr><td>98</td><td>Message not compatible with short message protocol state</td></tr>
 * <tr><td>99</td><td>Information element nonexistent or not implemented</td></tr>
 * <tr><td>111</td><td>Protocol error, unspecified</td></tr>
 * <tr><td>127</td><td>Interworking, unspecified</td></tr>
 * </table>
 * </p>
 */
public class CommunicationFailureException extends Exception {
	private int cause = 0;
	/**
	 * 例外の原因を示すCause値を設定してインスタンスを生成します。
	 *
	 * @param cause 3GPPで規定されているCause値を指定します。
	 */
	public CommunicationFailureException(int cause) {
		this(cause, null);
	}

	/**
	 * 例外の原因を示すCause値と詳細メッセージを設定してインスタンスを生成します。
	 *
	 * @param cause 3GPPで規定されているCause値を指定します。
	 * @param msg 詳細メッセージを指定します。
	 */
	public CommunicationFailureException(int cause, String msg) {
		super(msg);
		this.cause = cause;
		Logging.getInstance().putMethod(this, "CommunicationFailureException", msg);
	}

	/**
	 * 例外の原因を示すCause値を取得します。
	 *
	 * @return 例外の原因を示すCause値を返します。
	 */
	public int getCauseValue() {
		return cause;
	}
}
