/**
 *<p>
 *アプリケーションインストールやファイルアクセスに関するクラスを定義します。
 *</p>
 *用語定義
 *<ul>
 *<li>
 *FFS(Flash File System)<br>
 *モジュール内に複数格納される全てのアプリケーションから利用可能なファイルを扱うファイルシステムです。<br>
 *操作可能なファイル名は全て固定です。<br>
 *アプリケーションから操作可能なファイルには以下の2種類があります。<br>
 *<ul>
 *<li>通常ファイル:{@link com.docomo_um.io.FFSAccessManager}クラスで操作可能なファイルです。</li>
 *<li>特殊ファイル:ダウンロード領域とアプリケーション格納エリアの事を表します。{@link com.docomo_um.io.ApplicationInstallManager}クラスで操作可能です。{@link com.docomo_um.io.FFSAccessManager}クラスでは操作できないファイルです。</li>
 *</ul>
 *</li>
 *<li>
 *NVM(Non-Volatile Memory)<br>
 *モジュール内に複数格納されるアプリケーションが個別に利用するメモリ領域です。<br>
 *</li>
 *<li>
 *アプリケーション格納エリア<br>
 *アプリケーションが格納される領域です。<br>
 *アプリケーション格納エリアへの書き込み方法は以下の２つです。<br>
 *<ol>
 *<li>有線通信によって直接インストールします。</li>
 *<li>ダウンロード領域に格納したファイルを{@link com.docomo_um.io.ApplicationInstallManager#updateApplicationArea(FFSFile)}メソッドによってインストールします。</li>
 *</ol>
 *</li>
 *<li>
 *ダウンロード領域<br>
 *アプリケーション格納エリアに格納されたアプリケーションが通信IFまたはネットワーク通信を利用してバイナリをダウンロードします。<br>
 *このバイナリをアプリケーション格納エリアへ移動させる前に一時的に格納する領域です。<br>
 *</li>
 *</ul>
 *<b>留意事項</b><br>
 *FFSのファイルに書き込んだ情報は他アプリケーションによって書き換えられる可能性があります。<br>
 *アプリケーション固有の情報を保護したい場合はNVMを利用してください。<br>
 *</p>
 */

package com.docomo_um.io;

