package com.docomo_um.win;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SystemProperties {
	private static SystemProperties instance = null;
	private static String filename = "/nano/properties/system.pro";
	private static boolean logging = false;
	private static String logPath = "./log.txt";
	private static String termPort;
	public static SystemProperties getInstance() {
		if (instance == null) {
			instance = new SystemProperties();
		}
		return instance;
	}
	public boolean getLogging() {
		return logging;
	}
	public String getLogPath() {
		return logPath;
	}
	public String getTerminalPort() {
		return termPort;
	}
	private SystemProperties() {
		try {
			getFileProperties();
		} catch (IOException e) {
		}
	}
	private void getFileProperties() throws IOException{
		InputStream is;
		String value;
		try {
			is = new FileInputStream(filename);
		} catch (FileNotFoundException e) {
			return;
		}
		SDKProperties pro = new SDKProperties();
		pro.load(is);
		value = pro.getProperty("LOGGING", "false");
		logging = Boolean.valueOf(value);
		logPath = pro.getProperty("LOGFILE", logPath);
		termPort = pro.getProperty("TERMINAL", "COM8");
}
}
