package com.docomo_um.win;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Logging extends Thread{
	private static Logging instance;
	private static List<String> messageList;
	private LogListener logListener = null;
	/**
	 * コンストラクタ
	 */
	private Logging() {
		super();
		messageList = new ArrayList<String>();
	}
	/**
	 * インスタンスの取得
	 * @return
	 */
	public static Logging getInstance() {
		if (instance == null) {
			instance = new Logging();
		}
		return instance;
	}
	public void putMethodMessage(Object obj, String methodName, String message) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		put(obj.getClass() + " " + methodName + "() : " + (message == null ? "null" : message));
	}
	public void putMethod(Object obj, String methodName) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		put(obj.getClass() + " " + methodName + "()");
	}
	public void putMethod(Object obj, String methodName, String param1) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		put(obj.getClass() + " " + methodName + "(" + param1 + ")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + ")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2, String param3) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		param3 = (param3 == null ? "null" : param3);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + "," + param3 +")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2, String param3, String param4) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		param3 = (param3 == null ? "null" : param3);
		param4 = (param4 == null ? "null" : param4);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + "," + param3 + "," + param4 + ")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2, String param3, String param4, String param5) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		param3 = (param3 == null ? "null" : param3);
		param4 = (param4 == null ? "null" : param4);
		param5 = (param5 == null ? "null" : param5);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + "," + param3 + "," + param4 + "," + param5 + ")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2, String param3, String param4, String param5, String param6) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		param3 = (param3 == null ? "null" : param3);
		param4 = (param4 == null ? "null" : param4);
		param5 = (param5 == null ? "null" : param5);
		param6 = (param6 == null ? "null" : param6);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + "," + param3 + "," + param4 + "," + param5 + "," + param6 + ")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2, String param3, String param4, String param5, String param6, String param7) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		param3 = (param3 == null ? "null" : param3);
		param4 = (param4 == null ? "null" : param4);
		param5 = (param5 == null ? "null" : param5);
		param6 = (param6 == null ? "null" : param6);
		param7 = (param7 == null ? "null" : param7);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + "," + param3 + "," + param4 + "," + param5 + "," + param6 + "," + param7 + ")");
	}
	public void putMethod(Object obj, String methodName, String param1, String param2, String param3, String param4, String param5, String param6, String param7, String param8) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		param1 = (param1 == null ? "null" : param1);
		param2 = (param2 == null ? "null" : param2);
		param3 = (param3 == null ? "null" : param3);
		param4 = (param4 == null ? "null" : param4);
		param5 = (param5 == null ? "null" : param5);
		param6 = (param6 == null ? "null" : param6);
		param7 = (param7 == null ? "null" : param7);
		param8 = (param8 == null ? "null" : param8);
		put(obj.getClass() + " " + methodName + "(" + param1 + "," + param2 + "," + param3 + "," + param4 + "," + param5 + "," + param6 + "," + param7 + "," + param8 + ")");
	}
	/**
	 * ターミナルにメッセージ出力
	 * @param msg
	 */
	public void printTerminalMessage(String msg) {
		if (logListener != null) {
			logListener.onMessage(msg);
		}
	}
	/**
	 * ログメッセージをバッファに格納
	 * @param str
	 */
	public void put(String str) {
		if (!SystemProperties.getInstance().getLogging()) {
			return;
		}
		Date date = new Date();
		String message = new String(Long.toString(date.getTime()) + ":" + str + "\n");
		synchronized (this) {
			messageList.add(message);
		}
	}
	/**
	 * バッファから出力するログメッセージを取得
	 * @return
	 */
	public String get() {
		if (!SystemProperties.getInstance().getLogging()) {
			return null;
		}
		String msg = null;
		synchronized (this) {
			if (messageList.size() > 0) {
				msg = messageList.get(0);
				messageList.remove(0);
			}
		}
		return msg;
	}
	/**
	 * ログ出力開始
	 */
	@Override
	public void start() {
		if (SystemProperties.getInstance().getLogging()) {
			super.start();
		}
	}
	/**
	 * ログ出力停止
	 */
	public void stop() {
		this.interrupt();
	}
	/**
	 * リスナの登録
	 * @param listener
	 */
	public void setLogListener(LogListener listener) {
		logListener = listener;
	}
	/**
	 * ログ出力スレッド
	 */
	@Override
	public void run() {
		String logfilename = SystemProperties.getInstance().getLogPath();
		File file = new File(logfilename);
		if (!file.exists()) {
			try {
				file.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		FileOutputStream fos;
		try {
			fos = new FileOutputStream(file);
		} catch (FileNotFoundException e1) {
			return;
		}
		while (true) {
			String message;
			message = get();
			if (message == null) {
				try {
					Thread.sleep(200);
				} catch (InterruptedException e) {
					while ((message = get()) != null) {
						try {
							fos.write(message.getBytes());
						} catch (IOException e1) {
							e1.printStackTrace();
							break;
						}
//						System.out.println(message);
					}
					break;
				}
			}
			else {
				try {
					fos.write(message.getBytes());
				} catch (IOException e1) {
					e1.printStackTrace();
					break;
				}
//				System.out.println(message);
			}
		}
		try {
			fos.flush();
			fos.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
