package com.docomo_um.validator;

import java.util.ArrayList;
import java.util.List;

import com.docomo_um.util.StringUtil;

/**
 * 電話番号種別を検証します。
 */
public class PhoneNumberTypeValidator implements Validator {

	/** 有効な電話番号種別のリスト */
	private static final List<Integer> validTypeList = new ArrayList<Integer>(){{
		add(128);
		add(129);
		add(144);
		add(145);
	}};

	/** 必須フラグ */
	private boolean required = false;

	/** 電話番号 */
	private String phoneNumber = null;

	/**
	 * コンストラクタ
	 * @param phoneNumber
	 */
	public PhoneNumberTypeValidator(boolean required, String phoneNumber) {

		this.required = required;
		this.phoneNumber = phoneNumber;
	}

	/**
	 * 検証
	 */
	@Override
	public boolean validate(Object param) {

		String type = (String)param;

		// 空文字をチェックします。
		if(StringUtil.isEmpty(type)) {
			return this.required == false;
		}

		// 10進数の数字かチェックします。
		int value = 0;
		try {
			value = Integer.valueOf(type);
		} catch(NumberFormatException e) {
			return false;
		}

		// 有効な電話番号種別かチェックします。
		if(validTypeList.contains(value) == false) {
			return false;
		}

		/*
		 * (ATImD v110 3.2.84、3.2.85 から抜粋)
		 * ・ <da>パラメータの先頭が"+"、<da>パラメータに記号を含む場合、<toda>パラメータの値に144のみを許容すること。
		 * ・ <da>パラメータの先頭が"+"、<da>パラメータに記号を含まない場合、<toda>パラメータの値に145のみを許容すること。
		 */
		if(phoneNumber != null && phoneNumber.startsWith("+")) {
			// TT1_0006 2012/12/10 mod by ozawa.
			//if(value != 145) {
			//	return false;
			//}
			// ST2_0234 2013/01/23 mod by ozawa.
			//if(phoneNumber.indexOf('*') >= 0 || phoneNumber.indexOf('#') >= 0) {
			if(hasSymbolicChar(phoneNumber)) {
			// ST2_0234 2013/01/23 mod end.
				if(value != 144) {
					return false;
				}
			} else {
				if(value != 145) {
					return false;
				}
			}
			// TT1_0006 2012/12/10 mod end.
		}
		
		/*
		 * (ATImD v110 3.2.84、3.2.85 から抜粋)
		 * ・ <da>パラメータの先頭が"+"以外、<da>パラメータに記号を含む場合、<toda>パラメータの値に128のみを許容すること。
		 * ・ <da>パラメータの先頭が"+"以外、<da>パラメータに記号を含まない場合、<toda>パラメータの値に129のみを許容すること。
		 */
		if(phoneNumber != null && phoneNumber.startsWith("+") == false) {
			// TT1_0006 2012/12/10 mod by ozawa.
			//if(value != 129) {
			//	return false;
			//}
			// ST2_0234 2013/01/23 mod by ozawa.
			//if(phoneNumber.indexOf('*') >= 0 || phoneNumber.indexOf('#') >= 0) {
			if(hasSymbolicChar(phoneNumber)) {
			// ST2_0234 2013/01/23 mod end.
				if(value != 128) {
					return false;
				}
			} else {
				if(value != 129) {
					return false;
				}
			}
			// TT1_0006 2012/12/10 mod end.
		}
		
		return true;
	}

	// ST2_0234 2013/01/23 add by ozawa.
	private boolean hasSymbolicChar(String number) {
		
		for(int i = 0; i < number.length(); i++) {
			if(isSymbolicChar(number.charAt(i))) {
				return true;
			}
		}
		return false;
	}
	private boolean isSymbolicChar(char c) {

		final String SYMBOLIC_CHARACTOR = "*#AaBbCc";
		return (SYMBOLIC_CHARACTOR.indexOf(c) >= 0);
	}
	// ST2_0234 2013/01/23 add end.
}
