package com.docomo_um.validator;

import java.util.ArrayList;
import java.util.List;

/**
 * 国際アクセスコードを検証します。
 */
public class InternationalAccessCodeValidator implements Validator {

	/** 有効な国際アクセスコードのリスト */
	private static final List<Integer> validCodeList = new ArrayList<Integer>(){{
		add(129);
		add(145);
	}};

	/** 必須フラグ */
	private boolean required = false;

	/** SMSセンター番号 */
	private String centerNumber = null;

	/**
	 * コンストラクタ
	 * @param centerNumber
	 */
	public InternationalAccessCodeValidator(boolean required, String centerNumber) {

		this.required = required;
		this.centerNumber = centerNumber;
	}

	/**
	 * 検証
	 */
	@Override
	public boolean validate(Object param) {

		// ST2_0234 2013/01/23 mod by ozawa.
//		String code = (String)param;
//
//		// 空文字をチェックします。
//		if(StringUtil.isEmpty(code)) {
//			return this.required == false;
//		}
//
//		// 10進数の数字かチェックします。
//		int value = 0;
//		try {
//			value = Integer.valueOf(code);
//		} catch(NumberFormatException e) {
//			return false;
//		}
//
//		// 有効な国際アクセスコードかチェックします。
//		if(validCodeList.contains(value) == false) {
//			return false;
//		}
//
//		// SMSセンター番号の先頭文字が"+"の場合、国際アクセスコードが145であることをチェックします。
//		if(centerNumber != null && centerNumber.startsWith("+")) {
//			if(value != 145) {
//				return false;
//			}
//		}
//		
//		// SMSセンター番号の先頭文字が"+"ではない場合、国際アクセスコードが129であることをチェックします。
//		if(centerNumber != null && centerNumber.startsWith("+") == false) {
//			if(value != 129) {
//				return false;
//			}
//		}
//		return true;
		
		// 電話番号種別と同等の処理
		Validator validator = new PhoneNumberTypeValidator(required, centerNumber);
		return validator.validate(param);
		// ST2_0234 2013/01/23 mod end.
	}
}
