package com.docomo_um.util;

public class StringConverter {

	/**
	 * 文字列を、文字列で表現されたバイト列に変換します。
	 * 
	 * <p>
	 * 例）<br />
	 * <table style="border-spacing : 20px 0px;">
	 * <tr align = "center"><th>文字列</th><th></th><th>文字列で表現されたバイト列</th></tr>
	 * <tr><td>L"あ"(U+3042)</td><td>→</td><td>L"3042" (U+0033,U+0030,0034,0032)</td></tr>
	 * <tr><td>L"お"(U+304A)</td><td>→</td><td>L"304A" (U+0033,U+0030,0034,0041)</td></tr>
	 * <tr><td>L"輩"(U+8F29)</td><td>→</td><td>L"8F29" (U+0038,U+0046,0032,0039)</td></tr>
	 * </table>
	 * </p>
	 * 
	 * @param str 文字列
	 * @return 文字列で表現されたバイト列
	 */
	public static String convToAsciiByte(String str) {
		
		char convTbl[] = {
				'0', '1', '2', '3', '4', '5', '6', '7', 
				'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' 
		};
		StringBuilder sb = new StringBuilder(str.length() * 4);
		
		for(int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			sb.append(convTbl[(c & 0xF000) >> 12]);
			sb.append(convTbl[(c & 0x0F00) >> 8]);
			sb.append(convTbl[(c & 0x00F0) >> 4]);
			sb.append(convTbl[(c & 0x000F)]);
		}
		
		return sb.toString();
	}
	
	/**
	 * 文字列で表現されたバイト列を、文字列に変換します。
	 * 
	 * <p>
	 * 例）<br />
	 * <table style="border-spacing : 20px 0px;">
	 * <tr align = "center"><th>文字列で表現されたバイト列</th><th></th><th>文字列</th></tr>
	 * <tr><td>L"3042" (U+0033,U+0030,0034,0032)</td><td>→</td><td>L"あ"(U+3042)</td></tr>
	 * <tr><td>L"304A" (U+0033,U+0030,0034,0041)</td><td>→</td><td>L"お"(U+304A)</td></tr>
	 * <tr><td>L"8F29" (U+0038,U+0046,0032,0039)</td><td>→</td><td>L"輩"(U+8F29)</td></tr>
	 * </table>
	 * </p>
	 * 
	 * @param str 文字列で表現されたバイト列
	 * @return 文字列
	 */
	public static String convFromAsciiByte(String str) {
		
		StringBuilder sb = new StringBuilder(str.length() / 4);
		
		for(int i = 0; i < str.length(); i += 4) {
			int c1 = Character.digit(str.charAt(i), 16);
			int c2 = Character.digit(str.charAt(i + 1), 16);
			int c3 = Character.digit(str.charAt(i + 2), 16);
			int c4 = Character.digit(str.charAt(i + 3), 16);
			sb.append((char)(((c1 & 0xF) << 12) | ((c2 & 0xF) << 8) | ((c3 & 0xF) << 4) | (c4 & 0xF)));
		}
		
		return sb.toString();
	}
}
