package com.docomo_um.module.net.ssl;

import com.docomo_um.win.Logging;

/**
 * 証明書の不備が原因で発生する例外クラスです。
 */
public class IllegalCertificateException extends Exception {

	/**
	 * 例外の詳細メッセージを設定しないでインスタンスを生成します。 
	 */
	public IllegalCertificateException() {
		this(null);
	}

	/**
	 * 例外の詳細メッセージを設定してインスタンスを生成します。
	 * @param msg 詳細メッセージを指定します。
	 */
	public IllegalCertificateException(String msg) {
		super(msg);
		Logging.getInstance().putMethod(this, "IllegalCertificateException", msg);
	}
}
