package com.docomo_um.module.net;

import com.docomo_um.module.*;

/**
 *音声サービスを表すインターフェースです。
 *
 */
public interface VoiceExtensible {

	/**
	 *DTMFを送信します。
	 *<p>
	 *送信可能な文字は{0-9、#、*、A-D、a-d}です。 
	 *</p>
	 *@param message 送信する文字列を指定します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws CommunicationFailureException 通信異常の場合に発生します。
	 */
	void sendDTMF(String message) throws SessionException, CommunicationFailureException;


	/**
	 *着信時に音声着信のセッションを転送先電話番号に転送します。
	 *
	 *@throws SessionException 転送電話サービス未契約の場合や転送先不明の場合など、正常に処理できなかった場合に発生します。
	 *@throws CommunicationFailureException 通信異常の場合に発生します。
	 */
	void redirect() throws SessionException, CommunicationFailureException;

	/**
	 *着信時に音声着信のセッションを留守番電話サービスに転送します。
	 *
	 *@throws SessionException 留守番電話サービス未契約の場合など、正常に処理できなかった場合に発生します。
	 *@throws CommunicationFailureException 通信異常の場合に発生します。
	 */
	void sendAnswering() throws SessionException, CommunicationFailureException;

	/**
	 *着信時に音声着信を拒否します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 */
	void reject() throws SessionException ;
}
