package com.docomo_um.module.net;

import java.util.ArrayList;
import java.util.List;
import com.docomo_um.module.CommunicationFailureException;
import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ExternalStatusException;
import com.docomo_um.module.ModuleInfo;
import com.docomo_um.module.ModuleProperties;
import com.docomo_um.module.RegulationException;
import com.docomo_um.win.Logging;


/**
 *音声通信制御を表すクラスです。
 *<p>
 *発信は、{@link #createSession(String)} を使用して{@link VoiceSession} のインスタンスを作成し、作成したインスタンスで音声発信と切断を管理します。<br>
 *着信は、{@link #setModemControllerListener(ModemControllerListener)} で登録したリスナの引数として渡される{@link VoiceSession} のインスタンスで音声着信と切断を管理します。
 *</p>
 *
 *@see ModemController
 *@see VoiceSession
 */

public abstract class VoiceController extends ModemController {

	/**
	 *音声通信制御の機能の一つとして、送話音量設定を表します。
	 *@see #getAvailableFunction()
	 */
	public static final int AVAILABLE_FUNCTION_TYPE_SENDER_VOLUME_CONTROL =0;

	/**
	 *音声通信制御の機能の一つとして、受話音量設定を表します。
	 *@see #getAvailableFunction()
	 */
	public static final int AVAILABLE_FUNCTION_TYPE_RECEIVER_VOLUME_CONTROL =1;

	/**
	 *音声通信制御の機能の一つとして、エコーキャンセラを表します。
	 *@see #getAvailableFunction()
	 */
	public static final int AVAILABLE_FUNCTION_TYPE_ECHO_CANCELLER =2;

	/**
	 *音声通信制御の機能の一つとして、ノイズキャンセラを表します。
	 *@see #getAvailableFunction()
	 */
	public static final int AVAILABLE_FUNCTION_TYPE_NOISE_CANCELLER =3;

	/**
	 *音声通信制御の機能の一つとして、コールウェイトを表します。
	 *@see #getAvailableFunction()
	 */
	public static final int AVAILABLE_FUNCTION_TYPE_CALL_WAIT =4;

	/**
	 *音声通信制御の機能の一つとして、DTMF送信を表します。
	 *@see #getAvailableFunction()
	 */
	public static final int AVAILABLE_FUNCTION_TYPE_DTMF =5;

	/**
	 *通話中の着信呼動作の一つとして、転送電話を表します。
	 *@see #getArrivalCallAction()
	 */
	public static final int ARRIVALCALL_ACTION_REDIRECT = 0;

	/**
	 *通話中の着信呼動作の一つとして、留守番電話を表します。
	 *@see #getArrivalCallAction()
	 */
	public static final int ARRIVALCALL_ACTION_ANSWERING = 1;

	/**
	 *通話中の着信呼動作の一つとして、着信拒否を表します。
	 *@see #getArrivalCallAction()
	 */
	public static final int ARRIVALCALL_ACTION_REJECT = 2;

	/**
	 *通話中の着信呼動作の一つとして、通常着信を表します。
	 *@see #getArrivalCallAction()
	 */
	public static final int ARRIVALCALL_ACTION_CALL_WAIT = 3;


	/**
	 *アプリケーションが直接このコンストラクタを呼び出してインスタンスを生成することはできません。
	 *
	 */
	VoiceController(){
	}

	/**
	 *音声通信制御がサポートする機能を取得します。
	 *
	 *@return サポートする機能の一覧を返します。サポートする機能がない場合は null を返します。
	 *
	 *@see #AVAILABLE_FUNCTION_TYPE_CALL_WAIT
	 *@see #AVAILABLE_FUNCTION_TYPE_DTMF
	 *@see #AVAILABLE_FUNCTION_TYPE_ECHO_CANCELLER
	 *@see #AVAILABLE_FUNCTION_TYPE_NOISE_CANCELLER
	 *@see #AVAILABLE_FUNCTION_TYPE_RECEIVER_VOLUME_CONTROL
	 *@see #AVAILABLE_FUNCTION_TYPE_SENDER_VOLUME_CONTROL
	 */
	public int[] getAvailableFunction() {
		Logging.getInstance().putMethod(this, "getAvailableFunction");
		return NetProperties.getInstance().getAvailableFunction();
	}

	/**
	 *受話音量を設定します。<br>
	 *受話音量がサポートされていない状態で、本メソッドを呼んだ場合は何もしません。
	 *<p>
	 *受話音量の設定は不揮発保存されます。
	 *</p>
	 *
	 *@param rate 0～100の範囲で指定します。
	 *
	 *@throws IllegalArgumentException rateに範囲外の値が指定された場合に発生します。
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、受話音量の設定に失敗した場合に発生します。
	 */
	public void setReceiverVolume(int rate) throws SessionException, DeviceException {
		return;
	}
	/**
	 *送話音量ミュートの有効/無効を設定します。
	 *送話音量がサポートされていない状態で、本メソッドを呼んだ場合は何もしません。
	 *<p>
	 *送話音量ミュートの設定は不揮発保存されません。再起動した場合、設定は初期値（無効）になります。
	 *</p>
	 *@param enabled 送話音をミュートにする場合はtrueを、そうでない場合はfalseを指定します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、送話音量ミュートの設定に失敗した場合に発生します。
	 */
	public void setSenderVolumeMute(boolean enabled) throws SessionException, DeviceException {
		return;
	}

	/**
	 *エコーキャンセラの有効/無効を設定します。
	 *エコーキャンセラがサポートされていない状態で、本メソッドを呼んだ場合は何もしません。
	 *<p>
	 *エコーキャンセラの有効/無効設定は不揮発保存されます。
	 *</p>
	 *@param enabled エコーキャンセラを有効にする場合はtrueを、そうでない場合はfalseを指定します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、エコーキャンセラの設定に失敗した場合に発生します。
	 */
	public void setEchoCanceller(boolean enabled) throws SessionException, DeviceException {
		return;
	}

	/**
	 *ノイズキャンセラの有効/無効を設定します。
	 *ノイズキャンセラがサポートされていない状態で、本メソッドを呼んだ場合は何もしません。
	 *<p>
	 *ノイズキャンセラの有効/無効設定は不揮発保存されます。
	 *</p>
	 *
	 *@param enabled ノイズキャンセラを有効にする場合はtrueを、そうでない場合はfalseを指定します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、ノイズキャンセラの設定に失敗した場合に発生します。
	 */
	public void setNoiseCanceller(boolean enabled) throws SessionException, DeviceException {
		return;
	}

	/**
	 *通話中の着信呼動作のサービスを設定します。(転送電話、留守番電話、着信拒否、通常着信)
	 *<p>
	 *本メソッドで通話中の着信呼動作を通常着信({@link #ARRIVALCALL_ACTION_CALL_WAIT})に設定した場合は、
	 *{@link ModemControllerListener#onReceived(ModemController, Session)}がコールバックされることで着信が通知されます。<br>
	 *通常着信（{@link #ARRIVALCALL_ACTION_CALL_WAIT}）以外が設定された場合は着信されません。<br>
	 *ただし、次の状態において第2呼着信時があった場合は、通常着信({@link #ARRIVALCALL_ACTION_CALL_WAIT})に設定したときと同様に着信されます。
	 *<ul>
	 *<li>本メソッドで{@link #ARRIVALCALL_ACTION_REDIRECT 転送電話}を設定し、転送電話を未契約の状態</li>
	 *<li>本メソッドで{@link #ARRIVALCALL_ACTION_ANSWERING 留守番電話}を設定し、留守番電話を未契約の状態</li>
	 *<li>本メソッドで{@link #ARRIVALCALL_ACTION_REDIRECT 転送電話}を設定し、転送電話を契約しているが転送先電話番号が設定されていない状態</li>
	 *</ul>
	 *</p>
	 *
	 *@param action 通話中の着信呼動作
	 *
	 *@throws IllegalArgumentException actionに通話中の着信呼動作で定義されていない値を設定した場合に発生します。
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、通話中の着信呼動作の設定に失敗した場合に発生します。
	 *
	 *@see #ARRIVALCALL_ACTION_ANSWERING
	 *@see #ARRIVALCALL_ACTION_REJECT
	 *@see #ARRIVALCALL_ACTION_CALL_WAIT
	 *@see #ARRIVALCALL_ACTION_REDIRECT
	 *@see USSDServiceManager
	 */
	public void setArrivalCallAction(int action) throws SessionException, DeviceException {
		return;
	}

	/**
	 * 公共モード(ドライブモード)の有効／無効を設定します。
	 *
	 * {@link #setArrivalCallAction(int)}によって通話中の着信呼動作のサービスを設定している場合でも、着信呼動作はこのメソッドの設定が優先されます。
	 *
	 *@param enable 公共モード(ドライブモード)を有効にする場合はtrueを、そうでない場合はfalseを指定します。
	 *
	 *@throws DeviceException デバイスの故障により、公共モード(ドライブモード)の設定に失敗した場合に発生します。
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 */
	public void setDriveMode(boolean enable) throws DeviceException, SessionException {
	}

	/**
	 *キャッチホンサービスの有効／無効を設定します。
	 *このメソッドが正常終了するとキャッチホンサービスが設定されます。
	 *<p>
	 *キャッチホンサービスが既に有効の状態で本メソッドの引数にtrueを指定した場合や、
	 *キャッチホンサービスが既に無効の状態で本メソッドの引数にfalseを指定した場合でも、キャッチホンサービスの有効／無効を再設定します。
	 *</p>
	 *
	 *@param enable キャッチホンサービスを有効にする場合はtrueを、そうでない場合はfalseを指定します。
	 *
	 *@throws SessionException キャッチホン未契約の場合など、正常に処理できなかった場合に発生します。
	 *@throws RegulationException 規制による通信失敗の場合に発生します。
	 *@throws ExternalStatusException UIMが挿入されていない場合など、キャッチホンサービスの設定に失敗した場合に発生します。
	 */
	public void setCallWaiting(boolean enable) throws SessionException, RegulationException, ExternalStatusException {
	}

	/**
	 *<p>
	 *保留呼を通話呼に変更します。<br>
	 *通話呼と、保留呼または着信呼がある状態で本メソッドをコールすると、通話呼を保留呼にし、着信呼または保留呼を通話呼へ変更します。
	 *但し、着信呼のセッションに{@link VoiceSession#MANNER_MODE_TYPE_DRIVE}が設定されている場合、本メソッドをコールすると{@link SessionException}が発生します。<br>
	 *保留呼のみがある状態で本メソッドをコールすると、保留呼を通話呼に変更します。<br>
	 *上記状態以外の状態で本メソッドをコールした場合、{@link SessionException}が発生します。
	 *</p>
	 *
	 *@throws SessionException キャッチホン未契約の場合など、正常に処理できなかった場合に発生します。
	 *@throws CommunicationFailureException 通信異常の場合に発生します。
	 *
	 *@see VoiceController#getConnectedSession()
	 *@see VoiceSession#receive()
	 */
	public void changeHoldStatus() throws SessionException, CommunicationFailureException {
	}

	/**
	 *受話音量を取得します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、受話音量の設定値取得に失敗した場合に発生します。
	 *
	 *@return 受話音量を返します。
	 */
	public int getReceiverVolume() throws SessionException, DeviceException {
		return 0;
	}

	/**
	 *送話音量ミュートの有効/無効を取得します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *
	 *@return 送話音量ミュートの有効/無効を返します。
	 */
	public boolean isSenderVolumeMute() throws SessionException {
		return false;
	}
	/**
	 *エコーキャンセラの有効/無効を取得します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、エコーキャンセラの設定値取得に失敗した場合に発生します。
	 *
	 *@return エコーキャンセラの有効/無効を返します。
	 */
	public boolean isEchoCanceller() throws SessionException, DeviceException {
		return false;
	}

	/**
	 *ノイズキャンセラの有効/無効を取得します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、ノイズキャンセラの設定値取得に失敗した場合に発生します。
	 *
	 *@return ノイズキャンセラの有効/無効を返します。
	 */
	public boolean isNoiseCanceller() throws SessionException, DeviceException {
		return false;
	}

	/**
	 *通話中の着信呼動作のサービスを取得します。
	 *
	 *@return 通話中の着信呼動作を返します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、通話中の着信呼動作の設定値取得に失敗した場合に発生します。
	 *
	 *@see #ARRIVALCALL_ACTION_ANSWERING
	 *@see #ARRIVALCALL_ACTION_REJECT
	 *@see #ARRIVALCALL_ACTION_CALL_WAIT
	 *@see #ARRIVALCALL_ACTION_REDIRECT
	 */
	public int getArrivalCallAction() throws SessionException, DeviceException {
		return ARRIVALCALL_ACTION_ANSWERING;
	}

	/**
	 * 公共モード(ドライブモード)の有効／無効を取得します。
	 *
	 *@throws SessionException 内部エラーにより処理が中断した場合に発生します。
	 *@throws DeviceException デバイスの故障により、公共モード(ドライブモード)の設定値取得に失敗した場合に発生します。
	 *
	 *@return 公共モード(ドライブモード)の有効／無効を返します。
	 */
	public boolean isDriveMode() throws SessionException, DeviceException {
		return false;
	}

	/**
	 *<p>
	 *音声通信の接続を表すインスタンスを生成します。
	 *</p>
	 *@param destination 通話先の電話番号を指定します。電話番号は"0123456789"のように、ハイフンなどは入れずに指定します。使用可能な文字は{0-9、#、*、+、A-C、a-c}です。
	 *@return 音声通信の接続を表すインスタンスを返します。
	 *
	 *@throws NullPointerException destinationにnullが指定された場合に発生します。
	 *@throws IllegalArgumentException 桁数の上限を超えるdestinationを指定した場合や、不正なフォーマット（電話番号にハイフンが入っているなど）のdestinationを指定した場合に発生します。
	 *@throws SessionException destinationが電話発信対象外の番号の場合に発生します。
	 */
	@Override
	public Session createSession(String destination) throws SessionException {
		return null;
	}

	/**
	 *リスナを登録します。
	 *<p>
	 *音声通信制御の状態を通知するイベントを受けることができます。
	 *音声専用の通知(ガイダンス通知等)を受け取りたい場合は、listenerに{@link VoiceControllerListener 音声専用の情報通知リスナ}を指定してください。
	 *</p>
	 *<p>
	 *このインスタンスに登録できるリスナは1つだけです。<br>
	 *このメソッドを複数回呼出した場合、最後に登録したリスナだけが有効です。<br>
	 *null を指定すると、リスナの登録を削除します。
	 *</p>
	 */
	@Override
	public void setModemControllerListener(ModemControllerListener listener) {
	}

	/**
	 *現在音声通信が通話呼のSessionを取得します。
	 *
	 *@return 音声通信が通話中状態(通話呼)のSessionを返します。通話中状態(通話呼)のSessionが無い場合はnullを返します。
	 */
	@Override
	public Session getConnectedSession() {
		return null;
	}
}
