package com.docomo_um.module.net;

import com.docomo_um.win.Logging;

/**
 * 音声またはパケットの処理に失敗した場合に発生する例外クラスです。
 */
public class SessionException extends Exception {

	/** 例外の要因を示すステータス */
	private int status;

	/**
	 *例外の原因を示すステータスの一つで、ステータスが未定義であることを表します。
	 */
	public static final int UNDEFINED = 0;

	/**
	 *例外の原因を示すステータス値の一つで、再発信規制を表します。
	 */
	public static final int REDIAL_REGULATION = 1;

	/**
	 *例外の原因を示すステータス値の一つで、電話発信対象外の帯域で音声発信を行ったことを表します。
	 */
	public static final int USSD_VOICE_CALL = 2;

	/**
	 *例外の原因を示すステータス値の一つで、接続要求が拒否されたことを表します。
	 */
	public static final int REQUEST_REJECT = 3;

	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定しないでインスタンスを生成します。
	 * ステータス値は UNDEFINED に設定されます。
	 */
	public SessionException() {
		this(UNDEFINED);
	}

	/**
	 * 例外の原因を示すステータス値を設定してインスタンスを生成します。 
	 *
	 * @param status 例外の原因を示すステータス値を指定します。
	 */
	public SessionException(int status) {
		this(status, null);
	}
	/**
	 * 例外の原因を示すステータス値と詳細メッセージを設定してインスタンスを生成します。 
	 *
	 * @param status 設定するステータスの値を指定します。
	 * @param message 詳細メッセージを指定します。
	 */
	public SessionException(int status, String message) {
		super(message);
		Logging.getInstance().putMethod(this, String.valueOf(status), message);
		this.status = status;
	}
	/**
	 * 例外の原因を示すステータス値を取得します。
	 *
	 * @return 例外の原因を示すステータス値を返します。
	 */
	public int getStatus() {
		return status;
	}
}
