package com.docomo_um.module.net;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import com.docomo_um.win.SDKProperties;

public class NetProperties {

	private static NetProperties instance = null;
	private static String filename = "/nano/properties/net.pro";

	// 音声通信関連
	private int[] availableFunction;
	private boolean driveMode;
	private int receiverVolume;
	/** 通話中の着信呼動作*/
	private int arrivalCallAction = VoiceController.ARRIVALCALL_ACTION_CALL_WAIT;
	private boolean senderVolumeMute;
	private boolean echoCanceller;
	private boolean noiseCanceller;
	private boolean redirectService;
	private boolean answeringService;
	private boolean callWaiting;

	/** 留守番電話サービスの開始/停止 */
	private boolean enableAnsweringService;
	/** 転送電話サービスの開始/停止 */
	private boolean enableRedirectService;
	/** 転送先電話番号 */
	private String redirectNumber;

	// SMS関連
	private String smsDir;
	private String smsFormat;

	// メール関連
	private String mailDir;
	private String popAccount;
	private String popPassword;
	private String smtpAccount;
	private String smtpPassword;

	// 例外関連
	private boolean sessionException;
	private int sessionExceptionStatus;
	private String sessionExceptionMessage;

	private boolean ussdServiceException;
	private String ussdServiceExceptionMessage;

	private boolean shortMessageException;
	private int shortMessageExceptionStatus;
	private String shortMessageExceptionMessage;

	private boolean mailException;
	private int     mailExceptionStatus;
	private String mailExceptionMessage;

	/*
	 * コンストラクタ
	 */
	private NetProperties() {
		try {
			this.loadProperties();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 音声通信制御コマンドがサポートする機能を取得
	 *
	 * 0:SENDER_VOLUME_CONTROL
	 * 1:RECEIVER_VOLUME_CONTROL
	 * 2:ECHO_CANCELLER
	 * 3:NOISE_CANCELLER
	 * 4:CALL_WAIT
	 * 5:DTMF
	 * @return
	 */
	public int[] getAvailableFunction(){
		return availableFunction;
	}

	/**
	 * 通話中の着信呼動作の取得
	 * @return
	 */
	public int getArrivalCallAction() {
		return arrivalCallAction;
	}

	/**
	 * 通話中の着信呼動作の設定
	 * @param action
	 */
	public void setArrivalCallAction(int action) {
		arrivalCallAction = action;
	}

	/**
	 * ドライブモード設定を取得
	 * @return
	 */
	public boolean getDriveMode(){
		return driveMode;
	}
	/**
	 * ドライブモード設定を変更
	 * @param enable
	 */
	public void setDriveMode(boolean enable) {
		driveMode = enable;
	}
	/**
	 * 受話音量設定を取得
	 * @return
	 */
	public int getReceiverVolume(){
		return receiverVolume;
	}

	/**
	 * 送話音量ミュート設定を取得
	 * @return
	 */
	public boolean getSenderVolumeMute(){
		return senderVolumeMute;
	}

	/**
	 * エコーキャンセラ設定を取得
	 * @return
	 */
	public boolean getEchoCanceller(){
		return echoCanceller;
	}

	/**
	 * ノイズキャンセラ設定を取得
	 * @return
	 */
	public boolean getNoiseCanceller(){
		return noiseCanceller;
	}

	/**
	 * 転送電話サービスの契約有無設定を取得
	 * @return
	 */
	public boolean getRedirectService(){
		return redirectService;
	}

	/**
	 * 留守番電話サービスの契約有無設定を取得
	 * @return
	 */
	public boolean getAnsweringService(){
		return answeringService;
	}
	/**
	 * キャッチフォンサービスの有無を取得
	 * @return
	 */
	public boolean getCallWaiting() {
		return callWaiting;
	}

	/**
	 * 転送電話サービスの転送先電話番号を取得
	 * @return
	 */
	public String getRedirectNumber() {
		return redirectNumber;
	}
	/**
	 * 留守番電話サービスの開始/停止を取得
	 * @return
	 */
	public boolean getEnableAnsweringService() {
		return enableAnsweringService;
	}
	/**
	 * 転送電話サービスの開始/停止を取得
	 * @return
	 */
	public boolean getEnableRedirectService() {
		return enableRedirectService;
	}
	/**
	 * SMS格納ディレクトリの取得
	 * @throws IOException
	 */
	public String getSMSDir() {
		return smsDir;
	}

	/**
	 * SMSのメッセージフォーマットを設定
	 * @param format
	 */
	public void setSMSFormat(String format) {
		smsFormat = format;
	}
	/**
	 * SMSのメッセージフォーマットを取得
	 * @return
	 */
	public String getSMSFormat() {
		return smsFormat;
	}

	/**
	 * メール格納ディレクトリを取得
	 * @return
	 */
	public String getMailDirectory() {
		return mailDir;
	}

	/**
	 * POPサーバのアカウントを取得
	 * @return
	 */
	public String getPOPAccount() {
		return popAccount;
	}

	/**
	 * POPサーバのパスワードを取得
	 * @return
	 */
	public String getPOPPassword() {
		return popPassword;
	}

	/**
	 * SMTPサーバのアカウントを取得
	 * @return
	 */
	public String getSMTPAccount() {
		return smtpAccount;
	}

	/**
	 * SMTPサーバのパスワードを取得
	 * @return
	 */
	public String getSMTPPassword() {
		return smtpPassword;
	}
	/**
	 * USSDServiceExceptionの発生の有無を設定します。
	 * @param enable
	 * @param message
	 */
	public void setUSSDServiceException(boolean enable, String message) {
		ussdServiceException = enable;
		ussdServiceExceptionMessage = message;
	}
	/**
	 * USSDServiceExceptionの発生の有無を取得します。
	 * @return
	 */
	public boolean getUSSDServiceException() {
		return ussdServiceException;
	}

	public String getUSSDServiceExceptionMessage() {
		return ussdServiceExceptionMessage;
	}

	/**
	 * SessionExceptionの発生の有無を設定します。
	 * @param enable
	 * @param status
	 * @param message
	 */
	public void setSessionException(boolean enable, int status, String message) {
		sessionException = enable;
		sessionExceptionStatus = status;
		sessionExceptionMessage = message;
	}

	/**
	 * SessionExceptionの発生の有無を取得します。
	 * @return
	 */
	public boolean getSessionException() {
		return sessionException;
	}

	public int getSessionExcepitonStatus() {
		return sessionExceptionStatus;
	}

	public String getSessionExceptionMessage() {
		return sessionExceptionMessage;
	}

	/**
	 * mailExceptionの発生の有無を設定します。
	 * @param enable
	 * @param status
	 * @param message
	 */
	public void setMailException(boolean enable, int status, String message) {
		mailException = enable;
		mailExceptionStatus = status;
		mailExceptionMessage = message;
	}

	/**
	 * mailExceptionの発生の有無を取得します。
	 * @return
	 */
	public boolean getMailException() {
		return mailException;
	}

	public int getMailExceptionStatus() {
		return mailExceptionStatus;
	}

	public String getMailExceptionMessage() {
		return mailExceptionMessage;
	}

	/**
	 * ShortMessageException例外の発生の有無を指定します。
	 * @param enable
	 * @param status
	 * @param message
	 */
	public void setShortMessageException(boolean enable, int status, String message) {
		shortMessageException = enable;
		shortMessageExceptionStatus = status;
		shortMessageExceptionMessage = message;
	}

	/**
	 * ShortMessageException例外の発生の有無を取得します。
	 * @return
	 */
	public boolean getShortMessageException() {
		return shortMessageException;
	}

	public int getShortMessageExceptionStatus() {
		return shortMessageExceptionStatus;
	}

	public String getShortMessageExceptionMessage() {
		return shortMessageExceptionMessage;
	}

	/**
	 * ネット情報プロパティのインスタンスを取得
	 *
	 * @return モジュール情報プロパティのインスタンス
	 */
	public static NetProperties getInstance(){

		if(instance == null){
			instance = new NetProperties();
		}
		return instance;
	}

	/**
	 * ファイルからプロパティを取得
	 */
	private void loadProperties() throws IOException{
		InputStream is;
		String strBuf;

		try {
			is = new FileInputStream(filename);
		} catch (FileNotFoundException e) {
			return;
		}

		SDKProperties pro = new SDKProperties();
		pro.load(is);

		//AVAILABLEFUNCTION
		strBuf = pro.getProperty("AVAILABLEFUNCTION");
		if(strBuf != null){
			StringTokenizer token = new StringTokenizer(strBuf, ",");
			List<Integer> availableBuf = new ArrayList<Integer>();

			while(token.hasMoreTokens()){
				String str = token.nextToken();
				if(str.equals("SENDER_VOLUME_CONTROL")){
					availableBuf.add(VoiceController.AVAILABLE_FUNCTION_TYPE_SENDER_VOLUME_CONTROL );
				}
				else if(str.equals("RECEIVER_VOLUME_CONTROL")){
					availableBuf.add(VoiceController.AVAILABLE_FUNCTION_TYPE_RECEIVER_VOLUME_CONTROL);
				}
				else if(str.equals("ECHO_CANCELLER")){
					availableBuf.add(VoiceController.AVAILABLE_FUNCTION_TYPE_ECHO_CANCELLER);
				}
				else if(str.equals("NOISE_CANCELLER")){
					availableBuf.add(VoiceController.AVAILABLE_FUNCTION_TYPE_NOISE_CANCELLER);
				}
				else if(str.equals("CALL_WAIT")){
					availableBuf.add(VoiceController.AVAILABLE_FUNCTION_TYPE_CALL_WAIT);
				}
				else if(str.equals("DTMF")){
					availableBuf.add(VoiceController.AVAILABLE_FUNCTION_TYPE_DTMF);
				}
			}
			availableFunction = new int[availableBuf.size()];
			for(int i = 0; i < availableBuf.size(); i++){
				availableFunction[i] = availableBuf.get(i);
			}
		}

		// ARRIVALCALLACTION
		strBuf = pro.getProperty("ARRIVALCALLACTION");
		if(strBuf != null){
			if (strBuf.equals("REDIRECT")) {
				arrivalCallAction = VoiceController.ARRIVALCALL_ACTION_REDIRECT;
			}
			else if (strBuf.equals("ANSWERING")) {
				arrivalCallAction = VoiceController.ARRIVALCALL_ACTION_ANSWERING;
			}
			else if (strBuf.equals("REJECT")) {
				arrivalCallAction = VoiceController.ARRIVALCALL_ACTION_REJECT;
			}
			else {
				arrivalCallAction = VoiceController.ARRIVALCALL_ACTION_CALL_WAIT;
			}
		}

		//DRIVEMODE
		strBuf = pro.getProperty("DRIVEMODE", "FALSE");
		driveMode = Boolean.valueOf(strBuf);

		//RECEIVERVOLUME
		strBuf = pro.getProperty("RECEIVERVOLUME", "50");
		if(strBuf != null){
			receiverVolume = Integer.valueOf(strBuf);
			if(receiverVolume < 0){
				receiverVolume = 0;
			}
			else if(receiverVolume > 100){
				receiverVolume = 100;
			}
		}

		//SENDERVOLUMEMUTE
		strBuf = pro.getProperty("SENDERVOLUMEMUTE", "FALSE");
		senderVolumeMute = Boolean.valueOf(strBuf);

		//ECHOCANCELLER
		strBuf = pro.getProperty("ECHOCANCELLER", "FALSE");
		echoCanceller = Boolean.valueOf(strBuf);

		//NOISECANCELLER
		strBuf = pro.getProperty("NOISECANCELLER", "FALSE");
		noiseCanceller = Boolean.valueOf(strBuf);

		//REDIRECTSERVICE
		strBuf = pro.getProperty("REDIRECTSERVICE", "FALSE");
		redirectService = Boolean.valueOf(strBuf);

		//ANSWERINGSERVICE
		strBuf = pro.getProperty("ANSWERINGSERVICE", "FALSE");
		answeringService = Boolean.valueOf(strBuf);

		//CALLWAITING
		strBuf = pro.getProperty("CALLWAITING", "FALSE");
		callWaiting = Boolean.valueOf(strBuf);

		// 転送先電話番号
		redirectNumber = pro.getProperty("REDIRECTNUMBER");

		// 留守番電話サービスの開始/停止
		strBuf = pro.getProperty("ENABLEANSWERINGSERVICE", "FALSE");
		enableAnsweringService = Boolean.valueOf(strBuf);

		// 転送電話サービスの開始/停止
		strBuf = pro.getProperty("ENABLEREDIRECTSERVICE", "FALSE");
		enableRedirectService = Boolean.valueOf(strBuf);

		//SMSDIR
		smsDir = pro.getProperty("SMSDIR", "/nano/sms/");

		//SMSFORMAT
		strBuf = pro.getProperty("SMSFORMAT", ShortMessageManager.FORMAT_TEXT);
		if (strBuf.equals(ShortMessageManager.FORMAT_PDU)) {
			smsFormat = ShortMessageManager.FORMAT_PDU;
		}
		else {
			smsFormat = ShortMessageManager.FORMAT_TEXT;
		}

		mailDir = pro.getProperty("MAILDIR", "/nano/mail/");
		popAccount = pro.getProperty("POPACCOUNT");
		popPassword = pro.getProperty("POPPASSWORD");
		smtpAccount = pro.getProperty("SMTPACCOUNT");
		smtpPassword = pro.getProperty("SMTPPASSWORD");
	}

	/**
	 * IPアドレスの書式が正しいかどうかを判定します。
	 *
	 * @param addr
	 * @return 書式が正しい場合はtrue、書式が不正、及びnullの場合はfalse
	 */
	static public boolean isIPAddress(String addr) {

		int count = 0;
		int num = 0;
		if (addr == null) {
			return false;
		}
		StringTokenizer token = new StringTokenizer(addr, ".");
		while (token.hasMoreTokens()) {
			if (count > 3) {
				return false;
			}
			String str = token.nextToken();
			//全て数値で無ければ不正
			try {
				num = Integer.valueOf(str);
			}
			catch (NumberFormatException e) {
				return false;
			}
			//0～255の間の数値でなければ不正
			if (num < 0 || num > 255) {
				return false;
			}
			// クラスD、Eはエラー
			if (count == 0 && num > 223) {
				return false;
			}
			count++;
		}
		//数値4組で無いなら不正
		if(count != 4){
			return false;
		}
		return true;
	}
	/**
	 * アドレスがループバックアドレスかを判定します。
	 * @param addr
	 * @return
	 */
	static public boolean isLoopbackAddress(String addr) {
		int[] loopback = { 127,0,0,1 };
		int num;
		int count = 0;
		if (addr == null) {
			return false;
		}
		StringTokenizer token = new StringTokenizer(addr, ".");
		while (token.hasMoreTokens()) {
			if (count > 3) {
				return false;
			}
			String str = token.nextToken();
			//全て数値で無ければ不正
			try {
				num = Integer.valueOf(str);
			}
			catch (NumberFormatException e) {
				return false;
			}
			if (num != loopback[count++]) {
				return false;
			}
		}
		//数値4組で無いなら不正
		if(count != 4){
			return false;
		}
		return true;
	}
	/**
	 * 番号が有効な電話番号かをチェックします。
	 * @param number
	 * @return
	 */
	static public boolean isTelephonNumber(String number) {
		if (number == null) {
			return false;
		}
		if (number.length() <= 0 || number.length() > 80) {
			return false;
		}
		for (int i = 0; i < number.length(); i++) {
			char c = number.charAt(i);
			if (!((c >= '0' && c <= '9') ||
				  (c >= 'A' && c <= 'C') ||
				  (c >= 'a' && c <= 'c') ||
				  (c == '*') || (c == '#') || (c == '+'))) {
				return false;
			}
		}
		return true;
	}

	/**
	 * 電話番号が緊急呼かどうかを判定します。
	 * @param number
	 * @return
	 */
	static public boolean isEmergencyCall(String number) {
		if (number.equals("110"))
			return true;
		if (number.equals("118"))
			return true;
		if (number.equals("119"))
			return true;
		return false;
	}
}