package com.docomo_um.module.net;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.docomo_um.module.DeviceException;
import com.docomo_um.module.ModuleProperties;

public class AreaMailFunctions {
	private static AreaMailBox areaMailBoxInstance = null;
	/** メール保存数 */
	private final static int TOTALNUM = 8;
	/** メール格納ディレクトリ */
	private static String areaMailBoxDir;
	/** リスナ */
	private static ShortMessageBoxListener messageBoxListener = null;

	public static void initAreaMail(AreaMailBox instance) {
		areaMailBoxInstance = instance;
		areaMailBoxDir = NetProperties.getInstance().getSMSDir() + "AREA/";
		File file = new File(NetProperties.getInstance().getSMSDir());
		if (!file.exists()) {
			file.mkdir();
		}
		file = new File(areaMailBoxDir);
		if (!file.exists()) {
			file.mkdir();
		}
	}

	public static ShortMessage get(int messageNumber) throws DeviceException, ShortMessageException {
		if (!isValidMessageNumber(messageNumber)) {
			throw new IllegalArgumentException();
		}
		if (ModuleProperties.getInstance().getDeviceException()) {
			// DevaiceException
			throw new DeviceException();
		}
		if (NetProperties.getInstance().getShortMessageException()) {
			throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(),
					NetProperties.getInstance().getShortMessageExceptionMessage());
		}
		int number = (messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER);
		String filename = areaMailBoxDir + String.valueOf(number);
		File file = new File(filename);
		if (file.exists()) {
			ShortMessage msg = new ShortMessage();
			if (msg.loadFromFile(filename)) {
				msg.setMessageNumber(messageNumber);
				String stat = msg.getAttribute(ShortMessage.ATTR_STAT);
				if (stat.equals(ShortMessage.STAT_UNREAD)) {
					msg.setAttribute(ShortMessage.ATTR_STAT, ShortMessage.STAT_READ);
					msg.saveToFile(filename);
				}
				return msg;
			}
		}
		throw new IllegalArgumentException();

	}

	public static List<ShortMessage> get(String type) throws DeviceException, ShortMessageException {
		List<ShortMessage> list = new ArrayList<ShortMessage>();
		if (!type.equals(ShortMessage.STAT_READ) && !type.equals(ShortMessage.STAT_UNREAD)) {
			throw new IllegalArgumentException();
		}
		if (ModuleProperties.getInstance().getDeviceException()) {
			// DevaiceException
			throw new DeviceException();
		}
		if (NetProperties.getInstance().getShortMessageException()) {
			throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(),
					NetProperties.getInstance().getShortMessageExceptionMessage());
		}
		for (int i = 1; i <= TOTALNUM; i++) {
			ShortMessage message = new ShortMessage();
			if (message.loadFromFile(areaMailBoxDir + String.valueOf(i))) {
				if (message.getAttribute(ShortMessage.ATTR_STAT).equals(type)) {
					if (type.equals(ShortMessage.STAT_UNREAD)) {
						message.setAttribute(ShortMessage.ATTR_STAT, ShortMessage.STAT_READ);
						message.saveToFile(areaMailBoxDir + String.valueOf(i));
					}
					message.setMessageNumber(ShortMessageFunctions.PREFIX_AREAMAIL | i);
					list.add(message);
				}
			}
		}
		return list;
	}

	public static void delete(int messageNumber) throws DeviceException, ShortMessageException {
		if (!isValidMessageNumber(messageNumber)) {
			throw new IllegalArgumentException();
		}
		if (ModuleProperties.getInstance().getDeviceException()) {
			// DevaiceException
			throw new DeviceException();
		}
		if (NetProperties.getInstance().getShortMessageException()) {
			throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(),
					NetProperties.getInstance().getShortMessageExceptionMessage());
		}
		int number = (messageNumber & ShortMessageFunctions.MASK_MESSAGE_NUMBER);
		File file = new File(areaMailBoxDir + String.valueOf(number));
		if (file.exists()) {
			if (file.delete()) {
				return;
			}
			// 削除できなかった場合
			throw new DeviceException();
		}
		// ファイルが存在しなかった場合
		throw new IllegalArgumentException();
	}
	public static void delete(String type) throws DeviceException, ShortMessageException {
		if (!type.equals(AreaMailBox.DELETE_TYPE_READ) && !type.equals(AreaMailBox.DELETE_TYPE_ALL)) {
			throw new IllegalArgumentException();
		}
		if (ModuleProperties.getInstance().getDeviceException()) {
			// DevaiceException
			throw new DeviceException();
		}
		if (NetProperties.getInstance().getShortMessageException()) {
			throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(),
					NetProperties.getInstance().getShortMessageExceptionMessage());
		}

		List<ShortMessage> list = get(ShortMessage.STAT_READ);
		if (type.equals(AreaMailBox.DELETE_TYPE_ALL)) {
			List<ShortMessage> unreadlist = get(ShortMessage.STAT_UNREAD);
			for (int i = 0; i < unreadlist.size(); i++) {
				list.add(unreadlist.get(i));
			}
		}
		for (int i = 0; i < list.size(); i++) {
			ShortMessage msg = list.get(i);
			delete(msg.getMessageNumber());
		}
	}
	public static int getTotalMessageNumber() throws ShortMessageException, DeviceException {
		if (ModuleProperties.getInstance().getDeviceException()) {
			// DevaiceException
			throw new DeviceException();
		}
		if (NetProperties.getInstance().getShortMessageException()) {
			throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(),
					NetProperties.getInstance().getShortMessageExceptionMessage());
		}
		return TOTALNUM;
	}
	public static int getSavedMessageNumber() throws ShortMessageException, DeviceException {
		int num = 0;
		if (ModuleProperties.getInstance().getDeviceException()) {
			// DevaiceException
			throw new DeviceException();
		}
		if (NetProperties.getInstance().getShortMessageException()) {
			throw new ShortMessageException(NetProperties.getInstance().getShortMessageExceptionStatus(),
					NetProperties.getInstance().getShortMessageExceptionMessage());
		}
		for (int i = 1; i <= 8; i++) {
			File file = new File(areaMailBoxDir + String.valueOf(i));
			if (file.exists()) {
				num++;
			}
		}
		return num;
	}
	public static void setShortMessageBoxListener(ShortMessageBoxListener listener) {
		messageBoxListener = listener;
	}

	/**
	 * メッセージ番号が有効かチェックします。
	 * @param messageNumber
	 * @return
	 */
	static boolean isValidMessageNumber(int messageNumber) {
		if ((messageNumber & ShortMessageFunctions.PREFIX_AREAMAIL) == 0) {
			// 別の保存領域
			return false;
		}
		return true;
	}

	/**
	 * 受信処理（PCSDK固有）
	 * @param message
	 * @return
	 * @throws DeviceException
	 */
	public static boolean receive(ShortMessage message) throws DeviceException {
		Date tm = new Date();
		message.setAttribute(ShortMessage.ATTR_STAT, ShortMessage.STAT_UNREAD);
		message.setReceiveTime(tm.getTime());
		for (int i = 1; i <= TOTALNUM; i++) {
			File file = new File(areaMailBoxDir + String.valueOf(i));
			message.setMessageNumber(ShortMessageFunctions.PREFIX_AREAMAIL | i);
			if (!file.exists()) {
				if (ShortMessageManager.getShortMessageListener() != null) {
					message.setAttribute(ShortMessage.ATTR_STAT, ShortMessage.STAT_READ);
				}
				message.saveToFile(areaMailBoxDir + String.valueOf(i));
				if (messageBoxListener != null) {
					messageBoxListener.onReceived(areaMailBoxInstance, ShortMessageFunctions.PREFIX_AREAMAIL | i, message, false);
				}
				return true;
			}
		}

		ShortMessage deleteMessage = null;
		int messageNumber = 0;
		ShortMessage readedDeleteMessage = null;
		int readedMessageNumber = 0;
		for (int i = 1; i <= TOTALNUM; i++) {
			ShortMessage msg = new ShortMessage();
			if (msg.loadFromFile(areaMailBoxDir + String.valueOf(i))) {
				if (deleteMessage == null) {
					deleteMessage = msg;
					messageNumber = i;
				}
				else {
					if (deleteMessage.getReceiveTime() > msg.getReceiveTime()) {
						deleteMessage = msg;
						messageNumber = i;
					}
				}
				// 既読メッセージ番号取得
				if (msg.getAttribute(ShortMessage.ATTR_STAT).equals(ShortMessage.STAT_READ)) {
					if (readedDeleteMessage == null) {
						// 既読メッセージ番号取得が初回の場合
						readedDeleteMessage = msg;
						readedMessageNumber = i;
					}
					else {
						// 既読メッセージ番号取得が初回以外
						if (readedDeleteMessage.getReceiveTime() > msg.getReceiveTime()) {
							// 既読メッセージが保持していたものより最古の場合
							readedDeleteMessage = msg;
							readedMessageNumber = i;
						}
					}
				}

			}
		}
		// エリアメッセージフォルダに既読がある場合は、既読の古いメッセージ番号を削除対象にする。
		if (readedDeleteMessage != null) {
			deleteMessage = readedDeleteMessage;
			messageNumber = readedMessageNumber;
		}
		if (deleteMessage != null) {
			try {
				delete(ShortMessageFunctions.PREFIX_AREAMAIL | messageNumber);
				message.setMessageNumber(ShortMessageFunctions.PREFIX_AREAMAIL | messageNumber);
				if (ShortMessageManager.getShortMessageListener() != null) {
					message.setAttribute(ShortMessage.ATTR_STAT, ShortMessage.STAT_READ);
				}
				message.saveToFile(areaMailBoxDir + String.valueOf(messageNumber));
				if (messageBoxListener != null) {
					messageBoxListener.onReceived(areaMailBoxInstance, ShortMessageFunctions.PREFIX_AREAMAIL | messageNumber, message, true);
				}
			} catch (ShortMessageException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
			return true;
		}
		return false;
	}

}
